package com.ai.controller;

import com.ai.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@CrossOrigin
@RequestMapping("/user")
public class UserController {

    @Autowired
    private UserService userService;

    // http://localhost:8081/user/findAllUser
    @GetMapping("/findAllUser")
    public String findAllUser() {
        return userService.findAllUser().toString();
    }

    @GetMapping("/findUserById/{id}")
    public String findUserById(@PathVariable Long id){
        return userService.findUserById(id).toString();
    }

}
