package com.tykj.datatransfer.controller;

import com.tykj.datatransfer.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.Map;
@Api("上传接口")
@Controller
@RequestMapping("/uploadApi")
public class UserController {

    @Resource
    private UserService userService;
    @ApiOperation("读取excel")
    @PostMapping("/uploadExcel")
    @ResponseBody
    public Map<String,Object> uploadExcel(@RequestParam("file") MultipartFile file){
        return userService.importProfession(file);
    }
}
