package com.tykj.datatransfer.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.datatransfer.entity.User;
import com.tykj.datatransfer.mapper.UserMapper;
import com.tykj.datatransfer.service.UserService;
import com.tykj.datatransfer.util.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class UserServiceImpl extends ServiceImpl<UserMapper, User> implements UserService {
    @Resource
    private UserMapper userMapper;


    @Override
    public Map<String, Object> importProfession(MultipartFile file) {
        Map<String,Object> map=new HashMap<>();
        //获取文件的后缀名
        String fileName=file.getOriginalFilename();
        String pattern=fileName.substring(fileName.lastIndexOf(".")+1);
        List<List<String>> listContent=new ArrayList<>();
        String message="导入成功";
        try{
            if (file!=null){
                if(!ExcelUtil.isEXCEL(file)){
                    message="该文件不是excel文件";
                }else {
                    listContent=ExcelUtil.readExcelContents(file,pattern);
                    if(listContent.isEmpty()){
                        message="表格内容为空";
                    }else {
                        for (int i=0;i<listContent.size();i++){
                            User user=new User();
                            String base=listContent.get(i).get(0);
                            String name=listContent.get(i).get(1);
                            String sex=listContent.get(i).get(2);
                            String qita=listContent.get(i).get(3);
                            String qwe=listContent.get(i).get(4);
                            user.setSex(sex);
                            user.setName(name);
                            user.setBase(base);
                            user.setQita(qita);
                            user.setQwe(qwe);
                            //插入数据
                            userMapper.insert(user);
                        }
                    }
                }
            }else {
                message="未选择文件";
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        map.put("code",200);
        map.put("msg",message);
        map.put("data",fileName);
        return map;
    }
}
