package com.tykj.datatransfer.util;

import com.alibaba.excel.util.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.StringUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

import javax.print.DocFlavor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ExcelUtil {
    public static Workbook readExcel(MultipartFile file, String pattern) {
        Workbook workbook=null;
        if (file!=null){
            try{
                InputStream is = file.getInputStream();
                if("xls".equals(pattern)){
                    return workbook=new HSSFWorkbook(is);
                }else if("xlsx".equals(pattern)){
                    return workbook=new HSSFWorkbook(is);
                }else {
                    return null;
                }
            }catch (FileNotFoundException e){
                e.printStackTrace();
            }catch (IOException e){
                e.printStackTrace();
            }
        }
        return workbook;
    }

    public static boolean isEXCEL(MultipartFile file){
        if(file!=null){
            String fileName=file.getOriginalFilename();
            String suffix=fileName.substring(fileName.lastIndexOf(".")+1);
            suffix =suffix.toLowerCase();
            if("xls".equals(suffix)||"xlsx".equals(suffix)){
                return true;
            }
        }
        return false;
    }

    public static List<List<String>> readExcelContents(MultipartFile file,String pattern){
        List<List<String>> listsRow =new ArrayList<>();
        Workbook workbook=null;
        Sheet sheet=null;
        if(isEXCEL(file)){
            workbook=readExcel(file, pattern);
        }
        if (workbook!=null){
            //获取文档首个表格
            sheet= workbook.getSheetAt(0);
            int rowNum=sheet.getPhysicalNumberOfRows();
            Row row=null;
            String cellData=null;
            for(int i=1;i<rowNum;i++){
                row= sheet.getRow(i);
                List<String> listCell=new ArrayList<>();
                if(StringUtils.isBlank(row.getCell(0).toString())){
                    break;
                }
                for (int j=0;j<row.getLastCellNum();j++){
                    cellData=row.getCell(j).toString();
                    listCell.add(cellData);
                }
                listsRow.add(listCell);
            }
        }
        return  listsRow;
    }
}
