package com.tykj.szkjg.config;

import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.sql.DataSource;

@Configuration
@MapperScan(basePackages = "com.tykj.szkjg.mapper", sqlSessionTemplateRef = "sqlSeesion")
@EnableTransactionManagement
public class PrimaryConfig {
    @Autowired
    @Qualifier("primaryDataSource")
    private DataSource locationDataSource;

    @Primary
    @Bean(name = "sqlSessionFactoryLocation")
    public SqlSessionFactory sqlSessionFactoryLocation() throws Exception {
        MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
        factoryBean.setDataSource(locationDataSource);
        factoryBean.setTypeAliasesPackage("com.tykj.szkjg.pojo");
        return factoryBean.getObject();
    }
    @Bean(name = "primaryDataSource")
    @Primary
    public DataSourceTransactionManager dataSourceTransactionManager(){
        return new DataSourceTransactionManager(locationDataSource);
    }
    @Bean(name = "sqlSeesion")
    @Primary
    public SqlSessionTemplate sqlSessionTemplate(@Qualifier("sqlSessionFactoryLocation") SqlSessionFactory sqlSessionFactory)throws Exception{
        return  new SqlSessionTemplate(sqlSessionFactory);
    }
}
