package com.tykj.szkjg.config;

import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.sql.DataSource;

@Configuration
@MapperScan(basePackages = "com.tykj.szkjg.mapper", sqlSessionFactoryRef = "sqlSeesion1")
@EnableTransactionManagement
public class SecondaryConfig {
    @Autowired
    @Qualifier("secondaryDataSource")
    private DataSource locationDataSource;

    @Primary
    @Bean(name = "sqlSessionFactoryLocation1")
    public SqlSessionFactory sqlSessionFactoryLocation() throws Exception {
        MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
        factoryBean.setDataSource(locationDataSource);
        factoryBean.setTypeAliasesPackage("com.tykj.szkjg.entity");
        return factoryBean.getObject();
    }
    @Bean(name = "secondaryDataSource")
    @Primary
    public DataSourceTransactionManager dataSourceTransactionManager(){
        return new DataSourceTransactionManager(locationDataSource);
    }

    @Bean(name = "sqlSeesion1")
    public SqlSessionTemplate sqlSessionTemplate(@Qualifier("sqlSessionFactoryLocation1") SqlSessionFactory sqlSessionFactory)throws Exception{
        return  new SqlSessionTemplate(sqlSessionFactory);
    }

}
