package com.tykj.szkjg.controller;

import com.tykj.szkjg.entity.VO.ScienceKlVO;
import com.tykj.szkjg.entity.VO.ScienceMonthVO;
import com.tykj.szkjg.service.ScienceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
/**
 * @author syk
 */
@Api(tags = "科技大屏")
@RestController
@RequestMapping("/kj")
public class ScienceController {
    @Autowired
    private ScienceService scienceService;
    @GetMapping("/getRealtime")
    @ApiOperation("实时人数查看")
    public ResponseEntity<List<Object>> getKxSgCustomerFlowVO(){
        return ResponseEntity.ok(scienceService.getRealtime());
    }
    @GetMapping("/getWeek")
    @ApiOperation("全省近7天客流人数")
    public ResponseEntity<List<Object>>setScienceKlVO(){
        return ResponseEntity.ok(scienceService.getWeek());
    }

    @GetMapping("/getMonth")
    @ApiOperation("全省全年客流")
    public ResponseEntity<List<Object>>getMonth(){
        return ResponseEntity.ok(scienceService.getMonth());
    }

    @GetMapping("/setScienceKlVO1s")
    @ApiOperation("当年累计客流人数")
    public ResponseEntity<Object>getTotality(){
        return ResponseEntity.ok(scienceService.getTotality());
    }
}


