package com.tykj.szkjg.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tykj.szkjg.entity.VO.ScienceKlVO;
import com.tykj.szkjg.entity.VO.ScienceMonthVO;
import com.tykj.szkjg.entity.VO.ScienceVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author syk
 */
public interface ScienceService extends IService<ScienceVO> {
    /**
     * 缓存实时客流
     */
    void setScienceVo();

    /**
     * 缓存每周客流
     * @return 缓存每周客流
     */
    List<ScienceKlVO> setScienceKlVO();

    /**
     * 从redis里获取实时客流
     * @return 从redis里获取实时客流
     */
    List<Object> getRealtime();

    /**
     * 从redis里获取每周客流
     * @return 从redis里获取每周客流
     */
    List<Object> getWeek();

    /**
     * 缓存每月客流
     * @return 缓存每月客流
     */
    List<ScienceMonthVO> setMonth();

    /**
     * 从redis里获取每月客流
     * @return
     */
    List<Object> getMonth();

    /**
     * 从redis里获取全年累计客流
     * @return
     */
    Object  getTotality();
}
