package com.tykj.szkjg.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.szkjg.entity.KxHzskjgkl;
import com.tykj.szkjg.entity.VO.KxHzVO;
import com.tykj.szkjg.entity.VO.KxHzskjgVO;
import com.tykj.szkjg.entity.VO.KxHzskjgklVO;
import com.tykj.szkjg.mapper.KxHzskjgklMapper;
import com.tykj.szkjg.mapper.SlaveKxHzkjgklMapper;
import com.tykj.szkjg.pojo.SlaveKxHzskjgkl;
import com.tykj.szkjg.service.KxHzskjgklService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author syk
 */
@Service
public class KxHzskjgklServiceImpl  extends ServiceImpl<KxHzskjgklMapper, KxHzskjgkl> implements KxHzskjgklService {
    @Autowired
    private  KxHzskjgklMapper kxHzskjgklMapper;
    @Autowired
    private SlaveKxHzkjgklMapper slaveKxHzkjgklMapper;
    @Override
    public KxHzskjgklVO getKxHzskjgklVO() {
        QueryWrapper<KxHzskjgkl> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByDesc("create_time")
                .last("limit 1");
        KxHzskjgkl latestRecord = kxHzskjgklMapper.selectOne(queryWrapper);
        // 判断查询结果是否为 null
        if (Objects.nonNull(latestRecord)) {
            KxHzskjgklVO latestRecordVO = new KxHzskjgklVO();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            String time = latestRecord.getCreateTime();
            LocalDateTime dbTime = LocalDateTime.parse(time, formatter);
            if (dbTime.equals(now)) {
                latestRecordVO.setActualCustomerNum(latestRecord.getActualCustomerNum());
            } else {
                latestRecordVO.setActualCustomerNum("0");
            }
            latestRecordVO.setActualCustomerNum(latestRecord.getActualCustomerNum());
            latestRecordVO.setCommutersMaximum(latestRecord.getCommutersMaximum());
            latestRecordVO.setCumulativeCustomerNum(latestRecord.getCumulativeCustomerNum());
            latestRecordVO.setName("湖州市科学技术馆");
            latestRecordVO.setAddress("湖州市吴兴区仁皇山路999号");
            latestRecordVO.setTime("周三至周日9：00-16:00");
            latestRecordVO.setLongitude("120.09447");
            latestRecordVO.setLatitude("30.89676");
            SlaveKxHzskjgkl slaveKxHzskjgkl=new SlaveKxHzskjgkl();
            BeanUtils.copyProperties(latestRecord, slaveKxHzskjgkl);
            insertKxLpskjgkl(slaveKxHzskjgkl);
            return latestRecordVO;
        } else {
            return null;
        }
    }

    @Override
    public void insertKxLpskjgkl(SlaveKxHzskjgkl slaveKxHzskjgkl) {
        QueryWrapper<SlaveKxHzskjgkl> wrapper = new QueryWrapper<>();
        wrapper.eq("id",slaveKxHzskjgkl.getId());
        SlaveKxHzskjgkl exis=slaveKxHzkjgklMapper.selectById(slaveKxHzskjgkl.getId());
        if (exis != null) {
            return;
        }
        slaveKxHzkjgklMapper.insert(slaveKxHzskjgkl);
    }

    @Override
    public List<KxHzskjgVO> getKxHzskjgVO() {
        LocalDate today = LocalDate.now();
        LocalDate lastWeek = today.minusDays(7);
        QueryWrapper<KxHzskjgkl> queryWrapper = new QueryWrapper<>();
        queryWrapper.between("create_time",lastWeek,today)
                .orderByDesc("create_time");
        List<KxHzskjgkl> recordList = kxHzskjgklMapper.selectList(queryWrapper);
        List<KxHzskjgVO> result = new ArrayList<>();
        for (KxHzskjgkl record : recordList) {
            KxHzskjgVO recordVO = new KxHzskjgVO();
            recordVO.setTodayCustomerNum(record.getTodayCustomerNum());
            recordVO.setCreateTime(record.getCreateTime());
            result.add(recordVO);
            SlaveKxHzskjgkl slaveKxHzskjgkl=new SlaveKxHzskjgkl();
            BeanUtils.copyProperties(slaveKxHzskjgkl, record);
            insertKxLpskjgkl(slaveKxHzskjgkl);
        }
       return result;
    }

    @Override
    public List<KxHzVO> getKxHzVO() {
        LocalDateTime today = LocalDateTime.now();
        LocalDateTime lastYear = today.minusYears(1);
        List<KxHzVO> rs=new ArrayList<>();
        for (int i=1;i<=12;i++) {
            QueryWrapper<KxHzskjgkl> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("MONTH(create_time)", i)
                    .between("create_time", lastYear, today)
                    .orderByDesc("create_time")
                    .last("LIMIT 1");
            KxHzskjgkl kxHzskjgkl = kxHzskjgklMapper.selectOne(queryWrapper);
            if (Objects.nonNull(kxHzskjgkl)) {
                KxHzVO kxHzVO = new KxHzVO();
                kxHzVO.setMonthCustomerNum(kxHzskjgkl.getMonthCustomerNum());
                kxHzVO.setCreateTime(kxHzskjgkl.getCreateTime());
                rs.add(kxHzVO);
                SlaveKxHzskjgkl slaveKxHzskjgkl=new SlaveKxHzskjgkl();
                BeanUtils.copyProperties(slaveKxHzskjgkl, kxHzskjgkl);
                insertKxLpskjgkl(slaveKxHzskjgkl);
            }
        }
        return  rs;
    }




}
