package com.tykj.szkjg.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.szkjg.entity.KxHzskjgkl;
import com.tykj.szkjg.entity.KxJxskjgkl;
import com.tykj.szkjg.entity.VO.*;
import com.tykj.szkjg.mapper.KxHzskjgklMapper;
import com.tykj.szkjg.mapper.KxJxskjgklMapper;
import com.tykj.szkjg.service.KxHzskjgklService;
import com.tykj.szkjg.service.KxJxskjgklService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author syk
 */
@Service
public class KxJxskjgklServiceImpl extends ServiceImpl<KxJxskjgklMapper, KxJxskjgkl> implements KxJxskjgklService {
    @Autowired
    private KxJxskjgklMapper kxJxskjgklMapper;

    @Override
    public KxJxskjgklVO getKxJxskjgklVO() {
        QueryWrapper<KxJxskjgkl> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByDesc("create_time")
                .last("limit 1");
        KxJxskjgkl latestRecord = kxJxskjgklMapper.selectOne(queryWrapper);
        // 判断查询结果是否为 null
        if (Objects.nonNull(latestRecord)) {
            KxJxskjgklVO latestRecordVO = new KxJxskjgklVO();
            String str=String.valueOf(latestRecord.getActualCustomerNum());
            latestRecordVO.setActualCustomerNum(str);
            latestRecordVO.setCommutersMaximum(latestRecord.getCommutersMaximum());
            latestRecordVO.setCumulativeCustomerNum(latestRecord.getCumulativeCustomerNum());
            latestRecordVO.setName("嘉兴市科技馆");
            latestRecordVO.setAddress("嘉兴市秀洲区嘉北街道友谊街471号");
            latestRecordVO.setTime("周三至周日上午9:00-11:30，下午13:30-16:30 ");
            latestRecordVO.setLongitude("120.73528");
            latestRecordVO.setLatitude("30.77547");
            insertKxJxskjgkl(latestRecord);
            return latestRecordVO;
        } else {
            return null;
        }
    }

    @Override
    public void insertKxJxskjgkl(KxJxskjgkl kxJxskjgkl) {
        QueryWrapper<KxJxskjgkl> wrapper = new QueryWrapper<>();
        wrapper.eq("uuid", kxJxskjgkl.getUuid());
        KxJxskjgkl exist = kxJxskjgklMapper.selectOne(wrapper);
        if (exist != null) {
            return;
        }
        // 将数据插入到数据库
        kxJxskjgklMapper.insert(kxJxskjgkl);
    }

    @Override
    public List<KxJxskjgVO> getKxJxskjgVO() {
        LocalDate today = LocalDate.now();
        LocalDate lastWeek = today.minusDays(7);
        QueryWrapper<KxJxskjgkl> queryWrapper = new QueryWrapper<>();
        queryWrapper.between("create_time",lastWeek,today)
                .orderByDesc("create_time");
        List<KxJxskjgkl> recordList = kxJxskjgklMapper.selectList(queryWrapper);
        List<KxJxskjgVO> result = new ArrayList<>();
        for (KxJxskjgkl record : recordList) {
            KxJxskjgVO recordVO = new KxJxskjgVO();
            recordVO.setTodayCustomerNum(record.getTodayCustomerNum());
            recordVO.setCreateTime(record.getCreateTime());
            result.add(recordVO);
            insertKxJxskjgkl(record);
        }
        return result;
    }

    @Override
    public List<KxJxVO> getKxJxVO() {
        LocalDateTime today = LocalDateTime.now();
        LocalDateTime lastYear = today.minusYears(1);
        List<KxJxVO> rs=new ArrayList<>();
        for (int i=1;i<=12;i++) {
            QueryWrapper<KxJxskjgkl> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("MONTH(create_time)", i)
                    .between("create_time", lastYear, today)
                    .orderByDesc("create_time")
                    .last("LIMIT 1");
            KxJxskjgkl kxJxskjgkl = kxJxskjgklMapper.selectOne(queryWrapper);
            if (Objects.nonNull(kxJxskjgkl)) {
                KxJxVO kxJxVO = new KxJxVO();
                kxJxVO.setMonthCustomerNum(kxJxskjgkl.getMonthCustomerNum());
                kxJxVO.setCreateTime(kxJxskjgkl.getCreateTime());
                rs.add(kxJxVO);
                insertKxJxskjgkl(kxJxskjgkl);
            }
        }
        return  rs;
    }

}

