package com.tykj.szkjg.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.szkjg.entity.KxHzskjgkl;
import com.tykj.szkjg.entity.KxLpskjgkl;
import com.tykj.szkjg.entity.VO.*;
import com.tykj.szkjg.mapper.KxLpskjgklMapper;
import com.tykj.szkjg.service.KxLpskjgklService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author syk
 */
@Service
public class KxLpskjgklServiceImpl  extends ServiceImpl<KxLpskjgklMapper, KxLpskjgkl> implements KxLpskjgklService {
    @Autowired
    private KxLpskjgklMapper kxLpskjgklMapper;
    @Override
    public KxLpskjgklVO getKxLpskjgklVO() {
        QueryWrapper<KxLpskjgkl> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByDesc("create_time")
                .last("limit 1");
        KxLpskjgkl latestRecord = kxLpskjgklMapper.selectOne(queryWrapper);
        // 判断查询结果是否为 null
        if (Objects.nonNull(latestRecord)) {
            KxLpskjgklVO latestRecordVO = new KxLpskjgklVO();
            latestRecordVO.setCommutersMaximum(latestRecord.getCommutersMaximum());
            String str=String.valueOf(latestRecord.getActualCustomerNum());
            latestRecordVO.setActualCustomerNum(str);
            latestRecordVO.setAddress("浙江省杭州市临平区沿山路45号");
            latestRecordVO.setName("杭州市临平区科技馆");
            latestRecordVO.setTime("周三至周日9:00-16:30");
            latestRecordVO.setCumulativeCustomerNum(latestRecord.getCumulativeCustomerNum());
            insertKxLpskjgkl(latestRecord);
            return latestRecordVO;
        } else {
            return null;
        }
    }

    @Override
    public void insertKxLpskjgkl(KxLpskjgkl KxLpskjgkl) {
        QueryWrapper<KxLpskjgkl> wrapper = new QueryWrapper<>();
        wrapper.eq("uuid", KxLpskjgkl.getUuid());
        KxLpskjgkl exist = kxLpskjgklMapper.selectOne(wrapper);
        if (exist != null) {
            return;
        }
        kxLpskjgklMapper.insert(KxLpskjgkl);
    }

    @Override
    public List<KxLpskjgVO> getKxLpskjgVO() {
        LocalDate today = LocalDate.now();
        LocalDate lastWeek = today.minusDays(7);
        QueryWrapper<KxLpskjgkl> queryWrapper = new QueryWrapper<>();
        queryWrapper.between("create_time",lastWeek,today)
                .orderByDesc("create_time");
        List<KxLpskjgkl> recordList = kxLpskjgklMapper.selectList(queryWrapper);
        List<KxLpskjgVO> result = new ArrayList<>();
        for (KxLpskjgkl record : recordList) {
            KxLpskjgVO recordVO = new KxLpskjgVO();
            recordVO.setTodayCustomerNum(record.getTodayCustomerNum());
            recordVO.setCreateTime(record.getCreateTime());
            result.add(recordVO);
            insertKxLpskjgkl(record);
        }
        return result;
    }

    @Override
    public List<KxLpVO> getKxLpVO() {
        LocalDateTime today = LocalDateTime.now();
        LocalDateTime lastYear = today.minusYears(1);
        List<KxLpVO> rs=new ArrayList<>();
        for (int i=1;i<=12;i++) {
            QueryWrapper<KxLpskjgkl> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("MONTH(create_time)", i)
                    .between("create_time", lastYear, today)
                    .orderByDesc("create_time")
                    .last("LIMIT 1");
            KxLpskjgkl lp = kxLpskjgklMapper.selectOne(queryWrapper);
            if (Objects.nonNull(lp)) {
                KxLpVO kxLpVO = new KxLpVO();
                kxLpVO.setMonthCustomerNum(lp.getMonthCustomerNum());
                kxLpVO.setCreateTime(lp.getCreateTime());
                rs.add(kxLpVO);
                insertKxLpskjgkl(lp);
            }
        }
        return  rs;
    }


}
