package com.tykj.szkjg.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.szkjg.entity.KxHzskjgkl;
import com.tykj.szkjg.entity.KxLpskjgkl;
import com.tykj.szkjg.entity.KxSgCustomerFlow;
import com.tykj.szkjg.entity.VO.*;
import com.tykj.szkjg.mapper.KxSgCustomerFlowMapper;
import com.tykj.szkjg.service.KxSgCustomerFlowService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author syk
 */
@Service
public class KxSgCustomerFlowImpl extends ServiceImpl<KxSgCustomerFlowMapper, KxSgCustomerFlow> implements KxSgCustomerFlowService {
    @Autowired
    private KxSgCustomerFlowMapper kxSgCustomerFlowMapper;
    @Override
    public KxSgCustomerFlowVO getKxSgCustomerFlowVO() {
        QueryWrapper<KxSgCustomerFlow> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByDesc("tong_time")
                .last("limit 1");
        KxSgCustomerFlow latestRecord = kxSgCustomerFlowMapper.selectOne(queryWrapper);
        // 判断查询结果是否为 null
        if (Objects.nonNull(latestRecord)) {
            KxSgCustomerFlowVO latestRecordVO = new KxSgCustomerFlowVO();
            latestRecordVO.setTodaytotal(latestRecord.getTodaytotal());
            latestRecordVO.setMaxcapacity(latestRecord.getMaxcapacity());
            latestRecordVO.setAddress("杭州市拱墅区西湖文化广场A区");
            latestRecordVO.setName("浙江省科技馆");
            latestRecordVO.setTime("夏令时：周三至周日9:00-17:00\n" +
                    "冬令时：周三至周日9:00-16:30");
            latestRecordVO.setAlltotal(latestRecord.getAlltotal());
            insertKxSgCustomerFlow(latestRecord);
            return latestRecordVO;
        } else {
            return null;
        }
    }

    @Override
    public void insertKxSgCustomerFlow(KxSgCustomerFlow KxSgCustomerFlow) {
        QueryWrapper<KxSgCustomerFlow> wrapper = new QueryWrapper<>();
        wrapper.eq("uuid", KxSgCustomerFlow.getUuid());
        KxSgCustomerFlow exist = kxSgCustomerFlowMapper.selectOne(wrapper);
        if (exist != null) {
            return;
        }
        kxSgCustomerFlowMapper.insert(KxSgCustomerFlow);
    }

    @Override
    public List<KxSgCustomerFlowSevenVO> getKxSgCustomerFlowSevenVO() {
        LocalDate today = LocalDate.now();
        LocalDate lastWeek = today.minusDays(7);
        QueryWrapper<KxSgCustomerFlow> queryWrapper = new QueryWrapper<>();
        queryWrapper.between("tong_time",lastWeek,today)
                .orderByDesc("tong_time");
        List<KxSgCustomerFlow> recordList = kxSgCustomerFlowMapper.selectList(queryWrapper);
        List<KxSgCustomerFlowSevenVO> result = new ArrayList<>();
        for (KxSgCustomerFlow record : recordList) {
            KxSgCustomerFlowSevenVO recordVO = new KxSgCustomerFlowSevenVO();
            recordVO.setTongTime(record.getTongTime());
            recordVO.setTodaytotal(record.getTodaytotal());
            result.add(recordVO);
            insertKxSgCustomerFlow(record);
        }
        return result;
    }

    @Override
    public List<KxSgVO> getKxSgVO() {
        LocalDateTime today = LocalDateTime.now();
        LocalDateTime lastYear = today.minusYears(1);
        List<KxSgVO> rs=new ArrayList<>();
        for (int i=1;i<=12;i++) {
            QueryWrapper<KxSgCustomerFlow> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("MONTH(tong_time)", i)
                    .between("tong_time", lastYear, today)
                    .orderByDesc("tong_time")
                    .last("LIMIT 1");
            KxSgCustomerFlow kxSgCustomerFlow = kxSgCustomerFlowMapper.selectOne(queryWrapper);
            if (Objects.nonNull(kxSgCustomerFlow)) {
                KxSgVO kxSgVO = new KxSgVO();
                kxSgVO.setTongTime(kxSgCustomerFlow.getTongTime());
                kxSgVO.setAllTotal(kxSgCustomerFlow.getAlltotal());
                rs.add(kxSgVO);
                insertKxSgCustomerFlow(kxSgCustomerFlow);
            }
        }
        return  rs;
    }

}
