package com.tykj.szkjg.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.szkjg.entity.KxHzskjgkl;
import com.tykj.szkjg.entity.KxLpskjgkl;
import com.tykj.szkjg.entity.KxTzskjgkl;
import com.tykj.szkjg.entity.VO.*;
import com.tykj.szkjg.mapper.KxTzskjgklMapper;
import com.tykj.szkjg.service.KxTzskjgklService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author syk
 */
@Service
public class KxTzskjgklServiceImpl extends ServiceImpl<KxTzskjgklMapper, KxTzskjgkl> implements KxTzskjgklService {
    @Autowired
    private KxTzskjgklMapper kxTzskjgklMapperl;
    @Override
    public KxTzskjgklVO getKxTzskjgklVO() {
        QueryWrapper<KxTzskjgkl> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByDesc("create_time")
                .last("limit 1");
        KxTzskjgkl latestRecord = kxTzskjgklMapperl.selectOne(queryWrapper);
        // 判断查询结果是否为 null
        if (Objects.nonNull(latestRecord)) {
            KxTzskjgklVO latestRecordVO = new KxTzskjgklVO();
            latestRecordVO.setActualCustomerNum(latestRecord.getActualCustomerNum());
            latestRecordVO.setAddress("台州市椒江区爱华路118号");
            latestRecordVO.setCumulativeCustomerNum(latestRecord.getCumulativeCustomerNum());
            latestRecordVO.setName("台州市科技馆");
            latestRecordVO.setCommutersMaximum(latestRecord.getCommutersMaximum());
            latestRecordVO.setTime("周三至周日9:00-16:30");
            insertKxTzskjgkl(latestRecord);
            return latestRecordVO;
        } else {
            return null;
        }
    }

    @Override
    public void insertKxTzskjgkl(KxTzskjgkl KxTzskjgkl) {
        QueryWrapper<KxTzskjgkl> wrapper = new QueryWrapper<>();
        wrapper.eq("uuid", KxTzskjgkl.getUuid());
        KxTzskjgkl exist = kxTzskjgklMapperl.selectOne(wrapper);
        if (exist != null) {
            return;
        }
        kxTzskjgklMapperl.insert(KxTzskjgkl);
    }

    @Override
    public List<KxTzskjgVO> getKxTzskjgVO() {
        LocalDate today = LocalDate.now();
        LocalDate lastWeek = today.minusDays(7);
        QueryWrapper<KxTzskjgkl> queryWrapper = new QueryWrapper<>();
        queryWrapper.between("create_time",lastWeek,today)
                .orderByDesc("create_time");
        List<KxTzskjgkl> recordList = kxTzskjgklMapperl.selectList(queryWrapper);
        List<KxTzskjgVO> result = new ArrayList<>();
        for (KxTzskjgkl record : recordList) {
            KxTzskjgVO recordVO = new KxTzskjgVO();
            recordVO.setTodayCustomerNum(record.getTodayCustomerNum());
            recordVO.setCreateTime(record.getCreateTime());
            result.add(recordVO);
            insertKxTzskjgkl(record);
        }
        return result;
    }

    @Override
    public List<KxTzVO> getKxTzVO() {
        LocalDateTime today = LocalDateTime.now();
        LocalDateTime lastYear = today.minusYears(1);
        List<KxTzVO> rs=new ArrayList<>();
        for (int i=1;i<=12;i++) {
            QueryWrapper<KxTzskjgkl> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("MONTH(create_time)", i)
                    .between("create_time", lastYear, today)
                    .orderByDesc("create_time")
                    .last("LIMIT 1");
            KxTzskjgkl kxTzskjgkl = kxTzskjgklMapperl.selectOne(queryWrapper);
            if (Objects.nonNull(kxTzskjgkl)) {
                KxTzVO kxTzVO = new KxTzVO();
                kxTzVO.setMonthCustomerNum(kxTzskjgkl.getMonthCustomerNum());
                kxTzVO.setCreateTime(kxTzskjgkl.getCreateTime());
                rs.add(kxTzVO);
                insertKxTzskjgkl(kxTzskjgkl);
            }
        }
        return  rs;
    }


}
