package com.tykj.szkjg.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.szkjg.entity.VO.*;
import com.tykj.szkjg.mapper.ScienceMapper;
import com.tykj.szkjg.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * @author syk
 */
@Service
public class ScienceServiceImpl extends ServiceImpl<ScienceMapper, ScienceVO> implements ScienceService {
    @Autowired
    private KxHzskjgklService kxHzskjgklService;
    @Autowired
    private KxLpskjgklService kxLpskjgklService;
    @Autowired
    private KxSgCustomerFlowService kxSgCustomerFlowService;
    @Autowired
    private KxTzskjgklService kxTzskjgklService;
    @Autowired
    private KxJxskjgklService kxJxskjgklService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Override
    public void setScienceVo() {
        List<ScienceVO> list = new ArrayList<>();
        ScienceVO scienceVO = new ScienceVO();
        KxHzskjgklVO kxHzskjgklVO = kxHzskjgklService.getKxHzskjgklVO();
        scienceVO.setCommutersMaximum(kxHzskjgklVO.getCommutersMaximum());
        scienceVO.setActualCustomerNum(kxHzskjgklVO.getActualCustomerNum());
        scienceVO.setAddress(kxHzskjgklVO.getAddress());
        scienceVO.setCumulativeCustomerNum(kxHzskjgklVO.getCumulativeCustomerNum());
        scienceVO.setName(kxHzskjgklVO.getName());
        scienceVO.setTime(kxHzskjgklVO.getTime());
        scienceVO.setLongitude("120.09447");
        scienceVO.setLatitude("30.89676");
        scienceVO.setSummerTime("");
        scienceVO.setWinterTime("");
        list.add(scienceVO);
//        ScienceVO lp = new ScienceVO();
//        KxLpskjgklVO kxLpskjgklVO = kxLpskjgklService.getKxLpskjgklVO();
//        lp.setLatitude("30.43051");
//        lp.setTime(kxLpskjgklVO.getTime());
//        lp.setName(kxLpskjgklVO.getName());
//        lp.setAddress(kxLpskjgklVO.getAddress());
//        lp.setLongitude("120.30140");
//        lp.setCumulativeCustomerNum(kxLpskjgklVO.getCumulativeCustomerNum());
//        lp.setActualCustomerNum(kxLpskjgklVO.getActualCustomerNum());
//        lp.setCommutersMaximum(kxLpskjgklVO.getCommutersMaximum());
//        lp.setWinterTime("");
//        lp.setSummerTime("");
//        list.add(lp);
//        ScienceVO tz = new ScienceVO();
//        KxTzskjgklVO kxTzskjgklVO = kxTzskjgklService.getKxTzskjgklVO();
//        tz.setName(kxTzskjgklVO.getName());
//        tz.setActualCustomerNum(kxTzskjgklVO.getActualCustomerNum());
//        tz.setCommutersMaximum(kxTzskjgklVO.getCommutersMaximum());
//        tz.setAddress(kxTzskjgklVO.getAddress());
//        tz.setCumulativeCustomerNum(kxTzskjgklVO.getCumulativeCustomerNum());
//        tz.setLongitude("121.42177");
//        tz.setLatitude("28.66580");
//        tz.setTime(kxTzskjgklVO.getTime());
//        tz.setWinterTime("");
//        tz.setSummerTime("");
//        list.add(tz);
//        ScienceVO zjs = new ScienceVO();
//        KxSgCustomerFlowVO kxSgCustomerFlowVO = kxSgCustomerFlowService.getKxSgCustomerFlowVO();
//        zjs.setTime("");
//        zjs.setAddress(kxSgCustomerFlowVO.getAddress());
//        zjs.setName(kxSgCustomerFlowVO.getName());
//        zjs.setCommutersMaximum(kxSgCustomerFlowVO.getMaxcapacity());
//        zjs.setCumulativeCustomerNum(kxSgCustomerFlowVO.getAlltotal());
//        zjs.setActualCustomerNum(kxSgCustomerFlowVO.getTodaytotal());
//        zjs.setLatitude("30.28204");
//        zjs.setLongitude("120.17117");
//        zjs.setSummerTime("周三至周日9:00-17:00");
//        zjs.setWinterTime("周三至周日9:00-16:30");
//        list.add(zjs);
//        ScienceVO js=new ScienceVO();
//        KxJxskjgklVO kxJxskjgklVO=kxJxskjgklService.getKxJxskjgklVO();
//        js.setTime(kxJxskjgklVO.getTime());
//        js.setTime(kxJxskjgklVO.getTime());
//        js.setAddress(kxJxskjgklVO.getAddress());
//        js.setName(kxJxskjgklVO.getName());
//        js.setCommutersMaximum(kxJxskjgklVO.getCommutersMaximum());
//        js.setCumulativeCustomerNum(kxJxskjgklVO.getCumulativeCustomerNum());
//        js.setActualCustomerNum(kxJxskjgklVO.getActualCustomerNum());
//        js.setLatitude("30.77547");
//        js.setLongitude("120.73528");
//        js.setSummerTime("");
//        js.setWinterTime("");
//        list.add(js);
        redisTemplate.opsForValue().set("Science", JSON.toJSONString(list));
    }

    @Override
    public List<ScienceKlVO> setScienceKlVO() {
        List<ScienceKlVO> list = new ArrayList<>();
        int OneCount = 0;
        int TwoCount = 0;
        int ThereCount = 0;
        int FourCount = 0;
        int FiveCount = 0;
        int SixCount = 0;
        int SevenCount = 0;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        //今天
        LocalDateTime now = LocalDateTime.now();
        //前7天
        Period period = Period.ofWeeks(1);
        LocalDateTime lastWeekToday = now.minus(period);
        List<KxHzskjgVO> kxHzskjgVO = kxHzskjgklService.getKxHzskjgVO();
        List<KxLpskjgVO> kxLpskjgVO=kxLpskjgklService.getKxLpskjgVO();
        List<KxTzskjgVO> kxTzskjgklVO=kxTzskjgklService.getKxTzskjgVO();
        List<KxSgCustomerFlowSevenVO> kxSgCustomerFlowSevenVO=kxSgCustomerFlowService.getKxSgCustomerFlowSevenVO();
        List<KxJxskjgVO> kxJxskjgVO=kxJxskjgklService.getKxJxskjgVO();
        for (KxHzskjgVO hzskjgVO:kxHzskjgVO){
            if (Objects.nonNull(kxHzskjgVO)) {
                String time = hzskjgVO.getCreateTime();
                LocalDateTime dbTime = LocalDateTime.parse(time, formatter);
                DayOfWeek dayVo = dbTime.getDayOfWeek();
                if (dbTime.isAfter(lastWeekToday) && dbTime.isBefore(now)) {
                    switch (dayVo) {
                        case MONDAY:
                            OneCount += Integer.parseInt(hzskjgVO.getTodayCustomerNum());
                            break;
                        case TUESDAY:
                            TwoCount += Integer.parseInt(hzskjgVO.getTodayCustomerNum());
                            break;
                        case WEDNESDAY:
                            ThereCount += Integer.parseInt(hzskjgVO.getTodayCustomerNum());
                            break;
                        case THURSDAY:
                            FourCount += Integer.parseInt(hzskjgVO.getTodayCustomerNum());
                            break;
                        case FRIDAY:
                            FiveCount += Integer.parseInt(hzskjgVO.getTodayCustomerNum());
                            break;
                        case SATURDAY:
                            SixCount += Integer.parseInt(hzskjgVO.getTodayCustomerNum());
                            break;
                        case SUNDAY:
                            SevenCount += Integer.parseInt(hzskjgVO.getTodayCustomerNum());
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        for (KxLpskjgVO lpskjgVO:kxLpskjgVO){
            if (Objects.nonNull(kxLpskjgVO)) {
                String time = lpskjgVO.getCreateTime();
                LocalDateTime dbTime = LocalDateTime.parse(time, formatter);
                DayOfWeek dayVo = dbTime.getDayOfWeek();
                if (dbTime.isAfter(lastWeekToday) && dbTime.isBefore(now)) {
                    switch (dayVo) {
                        case MONDAY:
                            OneCount += Integer.parseInt(lpskjgVO.getTodayCustomerNum());
                            break;
                        case TUESDAY:
                            TwoCount += Integer.parseInt(lpskjgVO.getTodayCustomerNum());
                            break;
                        case WEDNESDAY:
                            ThereCount += Integer.parseInt(lpskjgVO.getTodayCustomerNum());
                            break;
                        case THURSDAY:
                            FourCount += Integer.parseInt(lpskjgVO.getTodayCustomerNum());
                            break;
                        case FRIDAY:
                            FiveCount += Integer.parseInt(lpskjgVO.getTodayCustomerNum());
                            break;
                        case SATURDAY:
                            SixCount += Integer.parseInt(lpskjgVO.getTodayCustomerNum());
                            break;
                        case SUNDAY:
                            SevenCount += Integer.parseInt(lpskjgVO.getTodayCustomerNum());
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        for (KxTzskjgVO kxTzskjgVO:kxTzskjgklVO){
            if (Objects.nonNull(kxTzskjgklVO)) {
                String time = kxTzskjgVO.getCreateTime();
                LocalDateTime dbTime = LocalDateTime.parse(time, formatter);
                DayOfWeek dayVo = dbTime.getDayOfWeek();
                if (dbTime.isAfter(lastWeekToday) && dbTime.isBefore(now)) {
                    switch (dayVo) {
                        case MONDAY:
                            OneCount += Integer.parseInt(kxTzskjgVO.getTodayCustomerNum());
                            break;
                        case TUESDAY:
                            TwoCount += Integer.parseInt(kxTzskjgVO.getTodayCustomerNum());
                            break;
                        case WEDNESDAY:
                            ThereCount += Integer.parseInt(kxTzskjgVO.getTodayCustomerNum());
                            break;
                        case THURSDAY:
                            FourCount += Integer.parseInt(kxTzskjgVO.getTodayCustomerNum());
                            break;
                        case FRIDAY:
                            FiveCount += Integer.parseInt(kxTzskjgVO.getTodayCustomerNum());
                            break;
                        case SATURDAY:
                            SixCount += Integer.parseInt(kxTzskjgVO.getTodayCustomerNum());
                            break;
                        case SUNDAY:
                            SevenCount += Integer.parseInt(kxTzskjgVO.getTodayCustomerNum());
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        for (KxSgCustomerFlowSevenVO kxSgCustomerFlow:kxSgCustomerFlowSevenVO){
            if (Objects.nonNull(kxSgCustomerFlowSevenVO)) {
                String time = kxSgCustomerFlow.getTongTime();
                LocalDateTime dbTime = LocalDateTime.parse(time, formatter);
                DayOfWeek dayVo = dbTime.getDayOfWeek();
                if (dbTime.isAfter(lastWeekToday) && dbTime.isBefore(now)) {
                    switch (dayVo) {
                        case MONDAY:
                            OneCount += Integer.parseInt(kxSgCustomerFlow.getTodaytotal());
                            break;
                        case TUESDAY:
                            TwoCount += Integer.parseInt(kxSgCustomerFlow.getTodaytotal());
                            break;
                        case WEDNESDAY:
                            ThereCount += Integer.parseInt(kxSgCustomerFlow.getTodaytotal());
                            break;
                        case THURSDAY:
                            FourCount += Integer.parseInt(kxSgCustomerFlow.getTodaytotal());
                            break;
                        case FRIDAY:
                            FiveCount += Integer.parseInt(kxSgCustomerFlow.getTodaytotal());
                            break;
                        case SATURDAY:
                            SixCount += Integer.parseInt(kxSgCustomerFlow.getTodaytotal());
                            break;
                        case SUNDAY:
                            SevenCount += Integer.parseInt(kxSgCustomerFlow.getTodaytotal());
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        for (KxJxskjgVO js:kxJxskjgVO){
            if (Objects.nonNull(kxLpskjgVO)) {
                String time = js.getCreateTime();
                LocalDateTime dbTime = LocalDateTime.parse(time, formatter);
                DayOfWeek dayVo = dbTime.getDayOfWeek();
                if (dbTime.isAfter(lastWeekToday) && dbTime.isBefore(now)) {
                    switch (dayVo) {
                        case MONDAY:
                            OneCount += Integer.parseInt(js.getTodayCustomerNum());
                            break;
                        case TUESDAY:
                            TwoCount += Integer.parseInt(js.getTodayCustomerNum());
                            break;
                        case WEDNESDAY:
                            ThereCount += Integer.parseInt(js.getTodayCustomerNum());
                            break;
                        case THURSDAY:
                            FourCount += Integer.parseInt(js.getTodayCustomerNum());
                            break;
                        case FRIDAY:
                            FiveCount += Integer.parseInt(js.getTodayCustomerNum());
                            break;
                        case SATURDAY:
                            SixCount += Integer.parseInt(js.getTodayCustomerNum());
                            break;
                        case SUNDAY:
                            SevenCount += Integer.parseInt(js.getTodayCustomerNum());
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        ScienceKlVO one=new ScienceKlVO();
        one.setWeek("周一");
        String str = String.valueOf(OneCount);
        one.setTodayCustomerNum(str);
        list.add(one);

        ScienceKlVO two=new ScienceKlVO();
        two.setWeek("周二");
        String strTwo = String.valueOf(TwoCount);
        two.setTodayCustomerNum(strTwo);
        list.add(two);

        ScienceKlVO three=new ScienceKlVO();
        three.setWeek("周三");
        String strThree = String.valueOf(ThereCount);
        three.setTodayCustomerNum(strThree);
        list.add(three);

        ScienceKlVO four=new ScienceKlVO();
        four.setWeek("周四");
        String strFour = String.valueOf(FourCount);
        four.setTodayCustomerNum(strFour);
        list.add(four);

        ScienceKlVO five=new ScienceKlVO();
        five.setWeek("周五");
        String strFive = String.valueOf(FiveCount);
        five.setTodayCustomerNum(strFive);
        list.add(five);

        ScienceKlVO six=new ScienceKlVO();
        six.setWeek("周六");
        String strSix = String.valueOf(SixCount);
        six.setTodayCustomerNum(strSix);
        list.add(six);

        ScienceKlVO seven=new ScienceKlVO();
        seven.setWeek("周日");
        String strSeven = String.valueOf(SevenCount);
        seven.setTodayCustomerNum(strSeven);
        list.add(seven);
        redisTemplate.opsForValue().set("Week", JSON.toJSONString(list));
        return list;
    }
        @Override
        public List<Object> getRealtime () {
            List<Object> rs = JSONObject.parseObject(redisTemplate.opsForValue().get("Science") + "",
                    new TypeReference<List<Object>>() {
                    });
            return rs;
        }

    @Override
    public List<Object> getWeek() {
        List<Object> rs = JSONObject.parseObject(redisTemplate.opsForValue().get("Week") + "",
                new TypeReference<List<Object>>() {
                });
        return rs;
    }

    @Override
    public List<ScienceMonthVO> setMonth() {
        List<ScienceMonthVO> list = new ArrayList<>();
        int JanuaryCount = 0;
        int FebruaryCount = 0;
        int MarchCount = 0;
        int AprilCount = 0;
        int MayCount = 0;
        int JuneCount = 0;
        int JulyCount = 0;
        int AugustCount = 0;
        int SeptemberCount = 0;
        int OctoberCount = 0;
        int NovemberCount = 0;
        int DecemberCount = 0;
        //累计总数
        int totality=0;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List<KxHzVO> kxHzVO=kxHzskjgklService.getKxHzVO();
        List<KxLpVO> kxLpVO=kxLpskjgklService.getKxLpVO();
        List<KxTzVO> kxTzVO=kxTzskjgklService.getKxTzVO();
        List<KxSgVO> kxSgVO=kxSgCustomerFlowService.getKxSgVO();
        List<KxJxVO> kxJxVO=kxJxskjgklService.getKxJxVO();
        for (KxHzVO hz:kxHzVO){
            if (Objects.nonNull(kxHzVO)){
                String time = hz.getCreateTime();
                LocalDateTime dbTime = LocalDateTime.parse(time, formatter);
                int month = dbTime.getMonthValue();
                switch (month){
                    case 1:
                        JanuaryCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=JanuaryCount;
                        break;
                    case 2:
                        FebruaryCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=FebruaryCount;
                        break;
                    case 3:
                        MarchCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=MarchCount;
                        break;
                    case 4:
                        AprilCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=AprilCount;
                        break;
                    case 5:
                        MayCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=MayCount;
                        break;
                    case 6:
                        JuneCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=JuneCount;
                        break;
                    case 7:
                        JulyCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=JulyCount;
                        break;
                    case 8:
                        AugustCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=AugustCount;
                        break;
                    case 9:
                        SeptemberCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=SeptemberCount;
                        break;
                    case 10:
                        OctoberCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=OctoberCount;
                        break;
                    case 11:
                        NovemberCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=NovemberCount;
                        break;
                    case 12:
                        DecemberCount += Integer.parseInt(hz.getMonthCustomerNum());
                        totality+=DecemberCount;
                        break;
                    default:
                        break;
                }
            }
        }
        for (KxLpVO lp:kxLpVO){
            if (Objects.nonNull(kxLpVO)){
                String time = lp.getCreateTime();
                LocalDateTime dbTime = LocalDateTime.parse(time, formatter);
                int month = dbTime.getMonthValue();
                switch (month){
                    case 1:
                        JanuaryCount += lp.getMonthCustomerNum();
                        totality+=JanuaryCount;
                        break;
                    case 2:
                        FebruaryCount += lp.getMonthCustomerNum();
                        totality+=FebruaryCount;
                        break;
                    case 3:
                        MarchCount += lp.getMonthCustomerNum();
                        totality+=MarchCount;
                        break;
                    case 4:
                        AprilCount += lp.getMonthCustomerNum();
                        totality+=AprilCount;
                        break;
                    case 5:
                        MayCount += lp.getMonthCustomerNum();
                        totality+=MayCount;
                        break;
                    case 6:
                        JuneCount += lp.getMonthCustomerNum();
                        totality+=JuneCount;
                        break;
                    case 7:
                        JulyCount += lp.getMonthCustomerNum();
                        totality+=JulyCount;
                        break;
                    case 8:
                        AugustCount += lp.getMonthCustomerNum();
                        totality+=AugustCount;
                        break;
                    case 9:
                        SeptemberCount += lp.getMonthCustomerNum();
                        totality+=SeptemberCount;
                        break;
                    case 10:
                        OctoberCount += lp.getMonthCustomerNum();
                        totality+=OctoberCount;
                        break;
                    case 11:
                        NovemberCount += lp.getMonthCustomerNum();
                        totality+=NovemberCount;
                        break;
                    case 12:
                        DecemberCount += lp.getMonthCustomerNum();
                        totality+=DecemberCount;
                        break;
                    default:
                        break;
                }
            }
        }
        for (KxTzVO tz:kxTzVO){
            if (Objects.nonNull(kxTzVO)){
                String time = tz.getCreateTime();
                LocalDateTime dbTime = LocalDateTime.parse(time, formatter);
                int month = dbTime.getMonthValue();
                switch (month){
                    case 1:
                        JanuaryCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=JanuaryCount;
                        break;
                    case 2:
                        FebruaryCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=FebruaryCount;
                        break;
                    case 3:
                        MarchCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=MarchCount;
                        break;
                    case 4:
                        AprilCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=AprilCount;
                        break;
                    case 5:
                        MayCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=MayCount;
                        break;
                    case 6:
                        JuneCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=JuneCount;
                        break;
                    case 7:
                        JulyCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=JulyCount;
                        break;
                    case 8:
                        AugustCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=AugustCount;
                        break;
                    case 9:
                        SeptemberCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=SeptemberCount;
                        break;
                    case 10:
                        OctoberCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=OctoberCount;
                        break;
                    case 11:
                        NovemberCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=NovemberCount;
                        break;
                    case 12:
                        DecemberCount += Integer.parseInt(tz.getMonthCustomerNum());
                        totality+=DecemberCount;
                        break;
                    default:
                        break;
                }
            }
        }
        for (KxSgVO sg:kxSgVO){
            if (Objects.nonNull(kxSgVO)){
                String time = sg.getTongTime();
                LocalDateTime dbTime = LocalDateTime.parse(time, formatter);
                int month = dbTime.getMonthValue();
                switch (month){
                    case 1:
                        JanuaryCount += Integer.parseInt(sg.getAllTotal());
                        totality+=JanuaryCount;
                        break;
                    case 2:
                        FebruaryCount += Integer.parseInt(sg.getAllTotal());
                        totality+=FebruaryCount;
                        break;
                    case 3:
                        MarchCount += Integer.parseInt(sg.getAllTotal());
                        totality+=MarchCount;
                        break;
                    case 4:
                        AprilCount += Integer.parseInt(sg.getAllTotal());
                        totality+=AprilCount;
                        break;
                    case 5:
                        MayCount += Integer.parseInt(sg.getAllTotal());
                        totality+=MayCount;
                        break;
                    case 6:
                        JuneCount += Integer.parseInt(sg.getAllTotal());
                        totality+=JuneCount;
                        break;
                    case 7:
                        JulyCount += Integer.parseInt(sg.getAllTotal());
                        totality+=JulyCount;
                        break;
                    case 8:
                        AugustCount += Integer.parseInt(sg.getAllTotal());
                        totality+=AugustCount;
                        break;
                    case 9:
                        SeptemberCount += Integer.parseInt(sg.getAllTotal());
                        totality+=SeptemberCount;
                        break;
                    case 10:
                        OctoberCount += Integer.parseInt(sg.getAllTotal());
                        totality+=OctoberCount;
                        break;
                    case 11:
                        NovemberCount += Integer.parseInt(sg.getAllTotal());
                        totality+=NovemberCount;
                        break;
                    case 12:
                        DecemberCount += Integer.parseInt(sg.getAllTotal());
                        totality+=DecemberCount;
                        break;
                    default:
                        break;
                }
            }
        }
        DateTimeFormatter jxTime = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        for (KxJxVO jx:kxJxVO){
            if (Objects.nonNull(kxJxVO)){
                String time = jx.getCreateTime();
                LocalDate dbTime = LocalDate .parse(time, jxTime);
                int month = dbTime.getMonthValue();
                switch (month){
                    case 1:
                        JanuaryCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=JanuaryCount;
                        break;
                    case 2:
                        FebruaryCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=FebruaryCount;
                        break;
                    case 3:
                        MarchCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=MarchCount;
                        break;
                    case 4:
                        AprilCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=AprilCount;
                        break;
                    case 5:
                        MayCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=MayCount;
                        break;
                    case 6:
                        JuneCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=JuneCount;
                        break;
                    case 7:
                        JulyCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=JulyCount;
                        break;
                    case 8:
                        AugustCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=AugustCount;
                        break;
                    case 9:
                        SeptemberCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=SeptemberCount;
                        break;
                    case 10:
                        OctoberCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=OctoberCount;
                        break;
                    case 11:
                        NovemberCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=NovemberCount;
                        break;

                    case 12:
                        DecemberCount += Integer.parseInt(jx.getMonthCustomerNum());
                        totality+=DecemberCount;
                        break;
                    default:
                        break;
                }
            }
        }
        ScienceMonthVO one=new ScienceMonthVO();
        one.setCreateTime("一月");
        String strOne=String.valueOf(JanuaryCount);
        one.setMonthCustomerNum(strOne);
        list.add(one);

        ScienceMonthVO two = new ScienceMonthVO();
        two.setCreateTime("二月");
        String strTwo = String.valueOf(FebruaryCount);
        two.setMonthCustomerNum(strTwo);
        list.add(two);

        ScienceMonthVO three = new ScienceMonthVO();
        three.setCreateTime("三月");
        String strThree = String.valueOf(MarchCount);
        three.setMonthCustomerNum(strThree);
        list.add(three);

        ScienceMonthVO four = new ScienceMonthVO();
        four.setCreateTime("四月");
        String strFour = String.valueOf(AprilCount);
        four.setMonthCustomerNum(strFour);
        list.add(four);

        ScienceMonthVO five = new ScienceMonthVO();
        five.setCreateTime("五月");
        String strFive = String.valueOf(MayCount);
        five.setMonthCustomerNum(strFive);
        list.add(five);

        ScienceMonthVO six = new ScienceMonthVO();
        six.setCreateTime("六月");
        String strSix = String.valueOf(JuneCount);
        six.setMonthCustomerNum(strSix);
        list.add(six);

        ScienceMonthVO seven = new ScienceMonthVO();
        seven.setCreateTime("七月");
        String strSeven = String.valueOf(JulyCount);
        seven.setMonthCustomerNum(strSeven);
        list.add(seven);

        ScienceMonthVO eight = new ScienceMonthVO();
        eight.setCreateTime("八月");
        String strEight = String.valueOf(AugustCount);
        eight.setMonthCustomerNum(strEight);
        list.add(eight);

        ScienceMonthVO nine = new ScienceMonthVO();
        nine.setCreateTime("九月");
        String strNine = String.valueOf(SeptemberCount);
        nine.setMonthCustomerNum(strNine);
        list.add(nine);

        ScienceMonthVO ten = new ScienceMonthVO();
        ten.setCreateTime("十月");
        String strTen = String.valueOf(OctoberCount);
        ten.setMonthCustomerNum(strTen);
        list.add(ten);

        ScienceMonthVO eleven = new ScienceMonthVO();
        eleven.setCreateTime("十一月");
        String strEleven = String.valueOf(NovemberCount);
        eleven.setMonthCustomerNum(strEleven);
        list.add(eleven);

        ScienceMonthVO twelve = new ScienceMonthVO();
        twelve.setCreateTime("十二月");
        String strTwelve = String.valueOf(DecemberCount);
        twelve.setMonthCustomerNum(strTwelve);
        list.add(twelve);
        redisTemplate.opsForValue().set("Month", JSON.toJSONString(list));
        System.out.println(totality);
        redisTemplate.opsForValue().set("totality",totality);
        return list;
    }


    @Override
    public List<Object> getMonth() {
        List<Object> rs = JSONObject.parseObject(redisTemplate.opsForValue().get("Month") + "",
                new TypeReference<List<Object>>() {
                });
        return rs;
    }

    @Override
    public Object  getTotality() {
        Object value = redisTemplate.opsForValue().get("totality");
        return value;
    }


}
