package com.example.sykdemo.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.exception.excel.ExcelImportException;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.example.sykdemo.entity.User;
import com.example.sykdemo.mapper.UserMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;

@Api(tags = "测试easypoi导入")
@RestController
@RequestMapping("/aa")
@Slf4j
public class EasyPoiController {

    @Resource
    private UserMapper userMapper;

    @PostMapping("/testImport")
    @ApiOperation("导入数据库")
    public void testImport(MultipartFile file) throws Exception {
        if (file == null || file.isEmpty()) {
            throw new IllegalArgumentException("上传的文件不能为空");
        }
        ImportParams importParams = new ImportParams();
        //标题列占得行数
        importParams.setTitleRows(0);
        //header列占的行数
        importParams.setHeadRows(1);
        List<User> users = ExcelImportUtil.importExcel(file.getInputStream(), User.class, importParams);
        for (User user : users) {
            userMapper.insert(user);
            log.info("成功插入：" + user);
        }
    }

    @PostMapping("/testImport2")
    @ApiOperation("导入数据库2 开启校验")
    public void testImport2(MultipartFile file) throws Exception {
        if (file == null || file.isEmpty()) {
            throw new IllegalArgumentException("上传的文件不能为空");
        }
        ImportParams importParams = new ImportParams();
        //是否开启校验
        importParams.setNeedVerfiy(true);
        //标题列占得行数
        importParams.setTitleRows(0);
        //header列占的行数
        importParams.setHeadRows(1);
        ExcelImportResult<User> result = ExcelImportUtil.importExcelMore(file.getInputStream(),
                User.class, importParams);
        //导入成功的数据
        List<User> list = result.getList();
        //失败结果集
        List<User> failList = result.getFailList();
        int successful = 0;
        int lose = 0;
        for (User user : list) {
            userMapper.insert(user);
            log.info("成功插入：" + user);
            successful++;
        }
        for (User user : failList) {
            log.info("失败的数据是" + user);
            lose++;
        }
        log.info("成功插入:" + successful + "条");
        log.info("失败:" + lose + "条");
    }


    //    public void test(List<User> rs) throws IOException {
//        ExportParams exportParams = new ExportParams();
//        exportParams.setSheetName("参与人员信息");
//        // 生成workbook 并导出
//        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, User.class, rs);
//        FileOutputStream outputStream=new FileOutputStream();
//        workbook.write(outputStream);
//        outputStream.close();
//        workbook.close();
//    }

    @GetMapping("/test")
    @ApiOperation("导出user")
    public void test(HttpServletResponse response,int pageNum,int pageSize) throws IOException {
        Page<User> page = new Page<>(pageNum, pageSize);
        Page<User> userPage = userMapper.selectPage(page, null);
        List<User> rs = userPage.getRecords();
        ExportParams exportParams = new ExportParams();
        exportParams.setSheetName("参与人员信息");
        // 生成 workbook 并导出
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, User.class, rs);
        try {
            OutputStream outputStream = response.getOutputStream();
            // 下面几行是为了解决文件名乱码的问题
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(UUID.randomUUID().toString().getBytes(), StandardCharsets.UTF_8) + ".xlsx");
            response.setContentType("application/vnd.ms-excel;charset=UTF-8");
            //关闭缓存
            response.setHeader("Pragma", "no-cache");
            //关闭缓存
            response.setHeader("Cache-Control", "no-cache");
            //为了让浏览器不要缓存页面，也可以利用Expires实体报关域，设置为0
            response.setDateHeader("Expires", 0);
            workbook.write(outputStream);
            workbook.close();
            outputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @PostMapping("/testImport3")
    @ApiOperation("导入数据库3 开启校验")
    public void testImport3(MultipartFile file) throws Exception {
        try {
            if (file == null || file.isEmpty()) {
                throw new IllegalArgumentException("上传的文件不能为空");
            }
            ImportParams importParams = new ImportParams();
            // 是否开启校验
            importParams.setNeedVerfiy(true);
            // 标题列占得行数
            importParams.setTitleRows(0);
            // header列占的行数
            importParams.setHeadRows(1);
            ExcelImportResult<User> result = ExcelImportUtil.importExcelMore(file.getInputStream(),
                    User.class, importParams);
            // 导入成功的数据
            List<User> list = result.getList();
            // 失败结果集
            List<User> failList = result.getFailList();
            int successful = 0;
            int failed = 0;
            for (User user : list) {
                userMapper.insert(user);
                log.info("成功插入：" + user);
                successful++;
            }
            for (User user : failList) {
                log.info("导入文件中存在无法插入的数据：" + user);
                failed++;
            }
            log.info("成功插入：" + successful + "条");
            log.info("失败：" + failed + "条");
        } catch (ExcelImportException e) {
            log.info("导入失败的数据是");

        }
    }
}

