package com.example.sykdemo.controller;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.example.sykdemo.entity.User;
import com.example.sykdemo.mapper.UserMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

@Api(tags = "测试easypoi导入")
@RestController
@RequestMapping("/aa")
public class EasyPoiController {

    @Resource
    private UserMapper userMapper;

    @PostMapping ("/testImport")
    @ApiOperation("导入数据库")
    public void testImport(MultipartFile file) throws Exception {
        if (file == null || file.isEmpty()) {
            throw new IllegalArgumentException("上传的文件不能为空");
        }
        ImportParams importParams = new ImportParams();
        //标题列占得行数
        importParams.setTitleRows(0);
        //header列占的行数
        importParams.setHeadRows(1);
        List<User> users = ExcelImportUtil.importExcel(file.getInputStream(), User.class, importParams);
        for (User user : users) {
            userMapper.insert(user);
        }
        users.forEach(System.out::println);
    }
}
