package com.example.demo.controller;

import net.coobird.thumbnailator.Thumbnails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.File;
import java.io.IOException;

@Controller
@RequestMapping("/imageCompressor")
public class ImageCompressorController {
    @GetMapping("/compress")
    @ResponseBody
    public String compress() throws IOException {
        File folder = new File("C:/Users/syk/Desktop/1");
        int sizeThreshold = 1024 * 1024; // 指定压缩后的文件大小
        double quality = 0.7; // 压缩质量为原图的 70%

        if (folder.isDirectory()) {
            File[] files = folder.listFiles();
            for (File file : files) {
                if (!file.isDirectory()) {
                    String fileName = file.getName();
                    if (fileName.toLowerCase().endsWith(".jpg") || fileName.toLowerCase().endsWith(".png")) { // 只处理 jpg 和 png 格式的图片
                        File destFile = new File("C:/Users/syk/Desktop/1" + fileName); // 压缩后的文件存储路径
                        Thumbnails.of(file).scale(1f).outputQuality(quality).toFile(destFile);
                        while (destFile.length() > sizeThreshold) {
                            Thumbnails.of(destFile).scale(0.9f).outputQuality(quality).toFile(destFile);
                        }
                    }
                }
            }
        }
        return "压缩完成";
    }
}