package com.example.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.mapper.MasterActivitiesMapper;
import com.example.mapper.SlaveActivitiesMapper;
import com.example.pojo.SlaveShareYlActivities;
import com.example.pojo.MasterShareYlActivities;
import com.example.service.MasterActivitiesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;

/**
 * @author syk
 */
@Service
@DS("master")
public class MasterActivitiesServiceImpl extends ServiceImpl<MasterActivitiesMapper, MasterShareYlActivities> implements MasterActivitiesService {

    @Autowired
    private MasterActivitiesMapper hpActivitiesMapper;
    @Autowired
    private SlaveActivitiesMapper mybatisActivities;


    @Override
    @DS("slave_1")
    public void transfer() {
        List<MasterShareYlActivities> dataList = transfer2();
        for (MasterShareYlActivities data : dataList) {
            SlaveShareYlActivities mybatisData = new SlaveShareYlActivities();
            mybatisData.setId(data.getId());
            mybatisData.setTitle(data.getTitle());
            mybatisData.setCover(data.getCover());
            mybatisData.setCode(data.getCode());
            mybatisData.setType(data.getType());
            mybatisData.setArea(data.getArea());
            mybatisData.setAddress(data.getAddress());
            mybatisData.setServiceType(data.getServiceType());
            mybatisData.setServiceObj(data.getServiceObj());
            mybatisData.setProject(data.getProject());
            mybatisData.setOrganizer(data.getOrganizer());
            mybatisData.setContractor(data.getContractor());
            mybatisData.setSponsor(data.getSponsor());
            mybatisData.setReleaseTime(data.getReleaseTime());
            mybatisData.setRecruitTime(data.getRecruitTime());
            mybatisData.setRecruitNumber(data.getRecruitNumber());
            mybatisData.setActivityTime(data.getActivityTime());
            mybatisData.setActivityTimeEnd(data.getActivityTimeEnd());
            mybatisData.setIntroduction(data.getIntroduction());
            mybatisData.setClaim(data.getClaim());
            mybatisData.setAdscriptionOrg(data.getAdscriptionOrg());
            mybatisData.setContactPerson(data.getContactPerson());
            mybatisData.setContactPhone(data.getContactPhone());
            mybatisData.setContactEmail(data.getContactEmail());
            mybatisData.setBranchId(data.getBranchId());
            mybatisData.setIsSign(data.getIsSign());
            mybatisData.setSignPrecision(data.getSignPrecision());
            mybatisData.setStatus(data.getStatus());
            mybatisData.setLatitude(data.getLatitude());
            mybatisData.setLongitude(data.getLongitude());
            mybatisData.setPeopleNumber(data.getPeopleNumber());
            mybatisData.setCreatedAt(data.getCreatedAt());
            mybatisData.setUpdatedAt(data.getUpdatedAt());
            mybatisData.setAdminId(data.getAdminId());
            mybatisData.setDataActiveStatus(data.getDataActiveStatus());
            mybatisData.setDataException(data.getDataException());
            mybatisData.setDataState(data.getDataState());
            mybatisData.setDataUpdateTime(data.getDataUpdateTime());
            mybatisActivities.insert(mybatisData);
        }
    }

    @Override
    public List<MasterShareYlActivities> transfer2() {
        QueryWrapper<MasterShareYlActivities> queryWrapper = new QueryWrapper<>();
        LocalDateTime startTime = LocalDateTime.now().minusMinutes(1);
        queryWrapper.ge("updated_at", startTime.toInstant(ZoneOffset.of("+8")).toEpochMilli());
        return hpActivitiesMapper.selectList(queryWrapper);
    }


}
