package com.example.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.mapper.MasterActivitiesMapper;
import com.example.mapper.MasterBranchesMapper;
import com.example.mapper.SlaveActivitiesMapper;
import com.example.mapper.SlaveBranchesMapper;
import com.example.pojo.MasterShareYlActivities;
import com.example.pojo.MasterShareYlBranches;
import com.example.pojo.SlaveShareYlActivities;
import com.example.pojo.SlaveShareYlBranches;
import com.example.service.MasterActivitiesService;
import com.example.service.MasterBranchesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
@Service
@DS("master")
public class MasterBranchesServiceImpl extends ServiceImpl<MasterBranchesMapper, MasterShareYlBranches> implements MasterBranchesService {

    @Autowired
    private MasterBranchesMapper masterBranchesMapper;
    @Autowired
    private SlaveBranchesMapper slaveBranchesMapper;

    @Override
    @DS("slave_1")
    public void transBranches() {
        List<MasterShareYlBranches> dataList = transfer2();
        for (MasterShareYlBranches data : dataList) {
            SlaveShareYlBranches mybatisData = new SlaveShareYlBranches();
            mybatisData.setId(data.getId());
            mybatisData.setUid(data.getUid());
            mybatisData.setName(data.getName());
            mybatisData.setUnitType(data.getUnitType());
            mybatisData.setUnitName(data.getUnitName());
            mybatisData.setCapacity(data.getCapacity());
            mybatisData.setLatitude(data.getLatitude());
            mybatisData.setStreet(data.getStreet());
            mybatisData.setCover(data.getCover());
            mybatisData.setArea(data.getArea());
            mybatisData.setLeaderName(data.getLeaderName());
            mybatisData.setLeaderPhone(data.getLeaderPhone());
            mybatisData.setFullAddress(data.getFullAddress());
            mybatisData.setAddress(data.getAddress());
            mybatisData.setContactPerson(data.getContactPerson());
            mybatisData.setContactPhone(data.getContactPhone());
            mybatisData.setLatitude(data.getLatitude());
            mybatisData.setLongitude(data.getLongitude());
            mybatisData.setCreatedAt(data.getCreatedAt());
            mybatisData.setUpdatedAt(data.getUpdatedAt());
            mybatisData.setDataActiveStatus(data.getDataActiveStatus());
            mybatisData.setDataException(data.getDataException());
            mybatisData.setDataState(data.getDataState());
            mybatisData.setDataUpdateTime(data.getDataUpdateTime());
            slaveBranchesMapper.insert(mybatisData);
        }
    }

    @Override
    public List<MasterShareYlBranches> transfer2() {
        QueryWrapper<MasterShareYlBranches> queryWrapper = new QueryWrapper<>();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime startTime = now.minusDays(250);
        queryWrapper.ge("updated_at",startTime);
        queryWrapper.le("updated_at",now);
        return masterBranchesMapper.selectList(queryWrapper);
    }
}
