package com.example.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.mapper.MasterTextbooksMapper;
import com.example.mapper.SlaveTextbooksMapper;
import com.example.pojo.MasterShareYlBranches;
import com.example.pojo.MasterShareYlTextbooks;
import com.example.pojo.SlaveShareYlBranches;
import com.example.pojo.SlaveShareYlTextbooks;
import com.example.service.MasterTextbooksService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
@Service
@DS("master")
public class MasterTextbooksServiceImpl extends ServiceImpl<MasterTextbooksMapper, MasterShareYlTextbooks> implements MasterTextbooksService {
    @Autowired
    private MasterTextbooksMapper masterTextbooksMapper;
    @Autowired
    private SlaveTextbooksMapper slaveTextbooksMapper;
    @Override
    @DS("slave_1")
    public void transTextbooks() {
        List<MasterShareYlTextbooks> dataList = transfer2();
        for (MasterShareYlTextbooks data : dataList) {
            SlaveShareYlTextbooks mybatisData = new SlaveShareYlTextbooks();
            mybatisData.setId(data.getId());
            mybatisData.setName(data.getName());
            mybatisData.setUnit(data.getUnit());
            mybatisData.setType(data.getType());
            mybatisData.setRemarks(data.getRemarks());
            mybatisData.setCreatedAt(data.getCreatedAt());
            mybatisData.setUpdatedAt(data.getUpdatedAt());
            mybatisData.setCover(data.getCover());
            mybatisData.setStatus(data.getStatus());
            mybatisData.setArea(data.getArea());
            mybatisData.setFile(data.getFile());
            mybatisData.setAdminId(data.getAdminId());
            mybatisData.setDataActiveStatus(data.getDataActiveStatus());
            mybatisData.setDataException(data.getDataException());
            mybatisData.setDataState(data.getDataState());
            mybatisData.setDataUpdateTime(data.getDataUpdateTime());
            slaveTextbooksMapper.insert(mybatisData);
        }
    }

    @Override
    public List<MasterShareYlTextbooks> transfer2() {
        QueryWrapper<MasterShareYlTextbooks> queryWrapper = new QueryWrapper<>();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime startTime = now.minusDays(280);
        queryWrapper.ge("updated_at",startTime);
        queryWrapper.le("updated_at",now);
        return masterTextbooksMapper.selectList(queryWrapper);
    }
}
