package com.example.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.mapper.MasterVolunteerApplysMapper;
import com.example.mapper.SlaveVolunteerApplysMapper;
import com.example.pojo.MasterShareYlVolunteerApplys;
import com.example.pojo.SlaveShareYlVolunteerApplys;
import com.example.service.MasterVolunteerApplysService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
@Service
@DS("master")
public class MasterVolunteerApplysServiceImpl extends ServiceImpl<MasterVolunteerApplysMapper, MasterShareYlVolunteerApplys> implements MasterVolunteerApplysService {
    @Autowired
    private MasterVolunteerApplysMapper masterVolunteerApplyesMapper;
    @Autowired
    private SlaveVolunteerApplysMapper slaveVolunteerApplyesMapper;

    @Override
    @DS("slave_1")
    public void transVolunteerApplyes() {
        List<MasterShareYlVolunteerApplys> dataList = transfer2();
        for (MasterShareYlVolunteerApplys data : dataList) {
            SlaveShareYlVolunteerApplys mybatisData = new SlaveShareYlVolunteerApplys();
            mybatisData.setId(data.getId());
            mybatisData.setName(data.getName());
            mybatisData.setUserId(data.getUserId());
            mybatisData.setPhone(data.getPhone());
            mybatisData.setIdCard(data.getIdCard());
            mybatisData.setArea(data.getArea());
            mybatisData.setGender(data.getGender());
            mybatisData.setFace(data.getFace());
            mybatisData.setNation(data.getNation());
            mybatisData.setEdu(data.getEdu());
            mybatisData.setJobTitle(data.getJobTitle());
            mybatisData.setWorkType(data.getWorkType());
            mybatisData.setWork(data.getWork());
            mybatisData.setServiceType(data.getServiceType());
            mybatisData.setServiceDomain(data.getServiceDomain());
            mybatisData.setIsExp(data.getIsExp());
            mybatisData.setExp(data.getExp());
            mybatisData.setStatus(data.getStatus());
            mybatisData.setUpdatedAt(data.getUpdatedAt());
            mybatisData.setCreatedAt(data.getCreatedAt());
            mybatisData.setBranchId(data.getBranchId());
            mybatisData.setDataActiveStatus(data.getDataActiveStatus());
            mybatisData.setDataException(data.getDataException());
            mybatisData.setDataState(data.getDataState());
            mybatisData.setDataUpdateTime(data.getDataUpdateTime());
            slaveVolunteerApplyesMapper.insert(mybatisData);
        }
    }

    @Override
    public List<MasterShareYlVolunteerApplys> transfer2() {
        QueryWrapper<MasterShareYlVolunteerApplys> queryWrapper = new QueryWrapper<>();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime startTime = now.minusDays(250);
        queryWrapper.ge("updated_at",startTime);
        queryWrapper.le("updated_at",now);
        return masterVolunteerApplyesMapper.selectList(queryWrapper);
    }
}
