package com.tykj.sjc.controller;

import com.tykj.sjc.service.SjcAcademicianService;
import com.tykj.sjc.service.SjcDcExpertService;
import com.tykj.sjc.service.SjcLearnMemberService;
import com.tykj.sjc.service.SjcScienceTechnologyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "qkh数据存储")
@RestController
@RequestMapping("/qkh")
@Slf4j
public class QkhController {
    @Resource
    private SjcAcademicianService sjcAcademicianService;

    @Resource
    private SjcDcExpertService sjcDcExpertService;

    @Resource
    private SjcLearnMemberService sjcLearnMemberService;

    @Resource
    private SjcScienceTechnologyService sjcScienceTechnologyService;


    @GetMapping("/saveDcExpert")
    @ApiOperation("专家信息存储")
    public void saveDcExpert(){
        sjcDcExpertService.saveDcExpert();
    }

    @GetMapping("/saveLearnMember")
    @ApiOperation("科技工作者信息存储")
    public void saveLearnMember(){
        sjcLearnMemberService.saveLearnMember();
    }

    @GetMapping("/saveScienceTechnology")
    @ApiOperation("青年科技工作者信息存储")
    public void saveScienceTechnology(){
        sjcScienceTechnologyService.saveScienceTechnology();
    }


    @GetMapping("/saveAll")
    @ApiOperation("青科汇数据仓所有数据存储")
    public void saveAll(){
        sjcDcExpertService.saveDcExpert();
        log.info("专家信息存储完成");
        sjcLearnMemberService.saveLearnMember();
        log.info("科技工作者信息存储完成");
        sjcScienceTechnologyService.saveScienceTechnology();
        log.info("青年科技工作者信息存储完成");
    }
}
