package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcAcademicianMapper;
import com.tykj.sjc.qkh_entity.SjcAcademician;
import com.tykj.sjc.service.SjcAcademicianService;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import javafx.util.Builder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class SjcAcademicianServiceImpl extends ServiceImpl<SjcAcademicianMapper, SjcAcademician> implements SjcAcademicianService {

    @Resource
    private SjcAcademicianMapper sjcAcademicianMapper;

    @Resource
    private BillRemote billRemote;

    @Override
    public void saveAcademician() {
        List<SjcAcademician> sjcAcademicians = sjcAcademicianMapper.selectList(null);
        List<SjcAcademician> rs=new ArrayList<>();
        for (SjcAcademician sjcAcademician : sjcAcademicians) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcAcademician.getName())
                    .s2(sjcAcademician.getPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcAcademician.setRandomId(randomId);
            rs.add(sjcAcademician);
        }
        updateBatchById(rs);
        log.info("院士信息存储了{}条数据",rs.size());
    }
}
