package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcDcExpertMapper;
import com.tykj.sjc.mapper.SjcLearnMemberMapper;
import com.tykj.sjc.qkh_entity.SjcDcExpert;
import com.tykj.sjc.qkh_entity.SjcLearnMember;
import com.tykj.sjc.service.SjcDcExpertService;
import com.tykj.sjc.service.SjcLearnMemberService;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class SjcLearnMemberServiceImpl extends ServiceImpl<SjcLearnMemberMapper, SjcLearnMember> implements SjcLearnMemberService {

    @Resource
    private SjcLearnMemberMapper sjcLearnMemberMapper;

    @Resource
    private BillRemote billRemote;


    @Override
    @Transactional
    public void saveLearnMember() {
        List<SjcLearnMember> sjcLearnMembers = sjcLearnMemberMapper.selectList(null);
        List<SjcLearnMember> rs = new ArrayList<>();
        for (SjcLearnMember sjcLearnMember : sjcLearnMembers) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcLearnMember.getName())
                    .s2(sjcLearnMember.getMobile())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcLearnMember.setRandomId(randomId);
            rs.add(sjcLearnMember);
        }
        log.info("开始存储科技工作者信息");
        updateBatchById(rs);
        log.info("科技工作者信息存储了{}条",rs.size());
    }
}
