package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcScienceTechnologyMapper;
import com.tykj.sjc.qkh_entity.SjcScienceTechnology;
import com.tykj.sjc.service.SjcScienceTechnologyService;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class SjcScienceTechnologyServiceImpl extends ServiceImpl<SjcScienceTechnologyMapper, SjcScienceTechnology> implements SjcScienceTechnologyService {

    @Resource
    private SjcScienceTechnologyMapper sjcScienceTechnologyMapper;

    @Resource
    private BillRemote billRemote;


    @Override
    @Transactional
    public void saveScienceTechnology() {
        List<SjcScienceTechnology> sjcScienceTechnologies = sjcScienceTechnologyMapper.selectList(null);
        List<SjcScienceTechnology> rs=new ArrayList<>();
        for (SjcScienceTechnology sjcScienceTechnology : sjcScienceTechnologies) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcScienceTechnology.getName())
                    .s2(sjcScienceTechnology.getPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcScienceTechnology.setRandomId(randomId);
            rs.add(sjcScienceTechnology);
        }
        log.info("开始存储青年科技工作者信息");
        updateBatchById(rs);
        log.info("青年科技工作者信息存储了{}条",rs.size());
    }
}
