package com.tykj.sjc.util;

import org.springframework.http.HttpStatus;

/**
 * 全局错误处理类，用于处理一些不容易定义的错误
 *
 * @author HuangXiahao
 **/
public class ApiException extends RuntimeException {

    private final ResponseObj responseObj;

    public ApiException(ResponseObj responseObj){
        this.responseObj = responseObj;
    }

    public ApiException(String message) {
        this.responseObj = new ResponseObj(message, HttpStatus.NO_CONTENT+"");
    }

    public ApiException(String message, String errorCode){
        this.responseObj = new ResponseObj(message,errorCode);
    }

    public ResponseObj getResponseObj() {
        return responseObj;
    }

    //    private ResponseEntity responseEntity;
//
//    public ApiException(ResponseEntity responseEntity) {
//        this.responseEntity = responseEntity;
//    }

//    public ApiException(String message) {
//        this.responseEntity = ResponseEntity.status(204).body(new ResultObj(message));
//    }
//
//    public ApiException(String message, Object data) {
//        this.responseEntity = ResponseEntity.status(204).body(new ResultObj(data, message));
//    }

//    public ApiException(String message) {
//        this.responseEntity = ResponseEntity.status(204).body(new ResponseObj(message));
//    }
//
//    public ApiException(String message, Object data) {
//        this.responseEntity = ResponseEntity.status(204).body(new ResponseObj(data, message));
//    }
//
//
//    public ResponseEntity getResponseEntity() {
//        return responseEntity;
//    }
//
//    public void setResponseEntity(ResponseEntity responseEntity) {
//        this.responseEntity = responseEntity;
//    }
}
