package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcAcademicianMapper;
import com.tykj.sjc.qkh_entity.SjcAcademician;
import com.tykj.sjc.qkh_entity.SjcActivity;
import com.tykj.sjc.service.SjcActivityService;
import com.tykj.sjc.mapper.SjcActivityMapper;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* @author tykj
* @description 针对表【sjc_activity】的数据库操作Service实现
* @createDate 2023-11-17 17:27:48
*/
@Service
@Slf4j
public class SjcActivityServiceImpl extends ServiceImpl<SjcActivityMapper, SjcActivity>
    implements SjcActivityService{
    @Resource
    private SjcActivityMapper sjcActivityMapper;

    @Resource
    private BillRemote billRemote;

    @Override
    @Transactional
    public void saveActivity() {
        List<SjcActivity> sjcActivityList = sjcActivityMapper.selectList(null);
        List<SjcActivity> rs=new ArrayList<>();
        for (SjcActivity sjcActivity : sjcActivityList) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcActivity.getContacts())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcActivity.setRandomId(randomId);
            rs.add(sjcActivity);
        }
        updateBatchById(rs);
        log.info("院士信息存储了{}条数据",rs.size());
    }
}




