package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcAcademicianMapper;
import com.tykj.sjc.mapper.SjcDcExpertMapper;
import com.tykj.sjc.qkh_entity.SjcAcademician;
import com.tykj.sjc.qkh_entity.SjcDcExpert;
import com.tykj.sjc.service.SjcAcademicianService;
import com.tykj.sjc.service.SjcDcExpertService;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class SjcDcExpertServiceImpl  extends ServiceImpl<SjcDcExpertMapper, SjcDcExpert> implements SjcDcExpertService {


    @Resource
    private BillRemote billRemote;

    @Resource
    private SjcDcExpertMapper sjcDcExpertMapper;


    @Override
    @Transactional
    public void saveDcExpert() {
        List<SjcDcExpert> sjcDcExperts = sjcDcExpertMapper.selectList(null);
        List<SjcDcExpert> rs=new ArrayList<>();
        for (SjcDcExpert sjcDcExpert : sjcDcExperts) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcDcExpert.getNAME())
                    .s2(sjcDcExpert.getPHONE())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcDcExpert.setRandomId(randomId);
            rs.add(sjcDcExpert);
        }
        log.info("开始存储专家信息");
        updateBatchById(rs);
        log.info("专家信息存储了{}条",rs.size());
    }
}
