package com.tykj.sjc.util;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
@Component
@Slf4j
public class BillRemote {
    @Resource
    private  RestTemplate restTemplate;

    @Value("${remote.bill.save.url}")
    private String billSaveUrl;

    public  String sendSaveBill(BillDTO billDTO){
        //设置头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> requestEntity = new HttpEntity<>(JSON.toJSONString(billDTO),headers);
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(billSaveUrl, requestEntity, String.class);
        if (responseEntity.getStatusCode() == HttpStatus.OK) {
            String body = responseEntity.getBody();
            log.info("保存业务信息成功！");
            return body;
        } else {
            throw new ApiException("远程调用保存业务信息失败");
        }
    }
}
