package com.tykj.sjc.controller;

import com.tykj.sjc.service.*;
import com.tykj.sjc.zlkp_entity.SjcKxLdActiveManagement;
import com.tykj.sjc.zlkp_entity.SjcQuests;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "zlkp数据存储")
@RestController
@RequestMapping("/zlkp")
@Slf4j
public class ZlkpController {

    @Resource
    private SjcExpertsService sjcExpertsService;

    @Resource
    private SjcShareYlActivitiesService sjcShareYlActivitiesService;

    @Resource
    private SjcShareYlActivityAppliesService sjcShareYlActivityAppliesService;

    @Resource
    private SjcShareYlBranchesService sjcShareYlBranchesService;

    @Resource
    private SjcQuestsService sjcQuestsService;

    @Resource
    private SjcShareYlVolunteerApplysService sjcShareYlVolunteerApplysService;

    @Resource
    private SjcActivitysService sjcActivitysService;

    @Resource

    private SjcTechnologyBasesService sjcTechnologyBasesService;

    @Resource
    private SjcKxActivityService sjcKxActivityService;

    @Resource
    private SjcKxApplyService sjcKxApplyService;

    @Resource
    private SjcKxActApplyService sjcKxActApplyService;

    @Resource
    private SjcKxLdActiveManagementService sjcKxLdActiveManagementService;

    @Resource
    private SjcAleArticleService sjcAleArticleService;

    @Resource
    private SjcKxSourceSpecialService sjcKxSourceSpecialService;

    @Resource
    private SjcActivityKindService sjcActivityKindService;

    @GetMapping("/saveExperts")
    @ApiOperation("科普专家信息存储")
    public void saveExperts(){
        sjcExpertsService.saveExperts();
    }

    @GetMapping("/saveShareYlActivities")
    @ApiOperation("银铃活动信息存储")
    public void saveShareYlActivities(){
        sjcShareYlActivitiesService.saveShareYlActivities();
    }

    @GetMapping("/saveShareYlActivityApplies")
    @ApiOperation("银龄参与活动人员信息存储")
    public void  saveShareYlActivityApplies(){
        sjcShareYlActivityAppliesService.saveShareYlActivityApplies();
    }

    @GetMapping("/saveShareYlBranches")
    @ApiOperation("银龄网点信息存储")
    public void saveShareYlBranches(){
        sjcShareYlBranchesService.saveShareYlBranches();
    }

    @GetMapping("/saveShareYlVolunteerApplys")
    @ApiOperation("银龄志愿信息存储")
    public void saveShareYlVolunteerApplys(){
        sjcShareYlVolunteerApplysService.saveShareYlVolunteerApplys();
    }

    @GetMapping("/saveQuests")
    @ApiOperation("银龄问卷反馈信息存储")
    public void saveQuests(){
        sjcQuestsService.saveQuests();
    }


    @GetMapping("/saveActivitys")
    @ApiOperation("活动信息存储")
    public void saveActivitys(){
        sjcActivitysService.saveActivitys();
    }

    @GetMapping("/saveTechnologyBases")
    @ApiOperation("基地信息存储")
    public void  saveTechnologyBases(){
        sjcTechnologyBasesService.saveTechnologyBases();
    }

    @GetMapping("/saveKxActivity")
    @ApiOperation("数字少年宫-假⽇营地⾯活动信息存储")
    public void saveKxActivity(){
        sjcKxActivityService.saveKxActivity();
    }

    @GetMapping("/saveKxApply")
    @ApiOperation("数字少年宫-⽹上报名活动参与信息存储")
    public void saveKxApply(){
        sjcKxApplyService.saveKxApply();
    }

    @GetMapping("/saveKxActApply")
    @ApiOperation("数字少年宫-⽹上报名活动信息存储")
    public void saveKxActApply(){
        sjcKxActApplyService.saveKxActApply();
    }

    @GetMapping("/saveKxLdActiveManagement")
    @ApiOperation("数字少年宫-流动少年宫活动信息存储")
    public void saveKxLdActiveManagement(){
        sjcKxLdActiveManagementService.saveKxLdActiveManagement();
    }


    @GetMapping("/saveAleArticle")
    @ApiOperation("文章信息存储")
    public void saveAleArticle(){
        sjcAleArticleService.saveAleArticle();
    }

    @GetMapping("/saveKxSourceSpecial")
    @ApiOperation("科普专题信息存储")
    public void saveKxSourceSpecial(){
        sjcKxSourceSpecialService.saveKxSourceSpecial();
    }

    @GetMapping("/saveActivityKind")
    @ApiOperation("竞答活动信息存储")
    public void saveActivityKind(){
        sjcActivityKindService.saveActivityKind();
    }

    @GetMapping("/saveAll")
    @ApiOperation("浙里科普数据仓所有敏感数据存储")
    public void saveAll(){
        sjcExpertsService.saveExperts();
        log.info("科普专家信息存储完成");
        sjcShareYlActivitiesService.saveShareYlActivities();
        log.info("银铃活动信息存储完成");
        sjcShareYlActivityAppliesService.saveShareYlActivityApplies();
        log.info("银铃参与活动人员信息存储完成");
        sjcShareYlBranchesService.saveShareYlBranches();
        log.info("银铃网点信息存储完成");
        sjcShareYlVolunteerApplysService.saveShareYlVolunteerApplys();
        log.info("银铃志愿者信息存储完成");
        sjcQuestsService.saveQuests();
        log.info("银铃问卷反馈信息存储完成");
        sjcActivitysService.saveActivitys();
        log.info("活动信息存储完成");
        sjcTechnologyBasesService.saveTechnologyBases();
        log.info("基地信息存储完成");
        sjcKxActivityService.saveKxActivity();
        log.info("数字少年宫-假⽇营地⾯活动信息存储完成");
        sjcKxApplyService.saveKxApply();
        log.info("数字少年宫-⽹上报名活动参与信息存储完成");
        sjcKxActApplyService.saveKxActApply();
        log.info("数字少年宫-⽹上报名活动信息存储完成");
        sjcKxLdActiveManagementService.saveKxLdActiveManagement();
        log.info("数字少年宫-流动少年宫活动信息存储完成");
        sjcAleArticleService.saveAleArticle();
        log.info("文章信息存储完成");
        sjcKxSourceSpecialService.saveKxSourceSpecial();
        log.info("科普专题信息存储完成");
        sjcActivityKindService.saveActivityKind();
        log.info("竞答活动信息存储完成");
        log.info("数据仓存储完成");
    }
}
