package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcActivityKind;
import com.tykj.sjc.service.SjcActivityKindService;
import com.tykj.sjc.mapper.SjcActivityKindMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* @author tykj
* @description 针对表【sjc_activity_kind】的数据库操作Service实现
* @createDate 2023-11-15 16:44:48
*/
@Service
@Slf4j
public class SjcActivityKindServiceImpl extends ServiceImpl<SjcActivityKindMapper, SjcActivityKind>
    implements SjcActivityKindService{

    @Resource
    private SjcActivityKindMapper sjcActivityKindMapper;

    @Resource
    private BillRemote billRemote;

    @Override
    @Transactional
    public void saveActivityKind() {
        List<SjcActivityKind> rs=new ArrayList<>();
        for (SjcActivityKind sjcActivityKind : sjcActivityKindMapper.selectList(null)) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcActivityKind.getContactUser())
                    .s2(sjcActivityKind.getContactPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcActivityKind.setRandomId(randomId);
            rs.add(sjcActivityKind);
        }
        log.info("开始存储竞答活动信息");
        updateBatchById(rs);
        log.info("竞答活动信息存储了{}条",rs.size());
    }
}




