package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcActivitysMapper;
import com.tykj.sjc.service.SjcActivitysService;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcActivitys;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class SjcActivitysServiceImpl extends ServiceImpl<SjcActivitysMapper, SjcActivitys> implements SjcActivitysService {

    @Resource
    private SjcActivitysMapper sjcActivitysMapper;

    @Resource
    private BillRemote billRemote;

    @Override
    @Transactional
    public void saveActivitys() {
        List<SjcActivitys> sjcActivitys = sjcActivitysMapper.selectList(null);
        List<SjcActivitys> rs=new ArrayList<>();
        for (SjcActivitys sjcActivity : sjcActivitys) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcActivity.getContactPerson())
                    .s2(sjcActivity.getContactPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcActivity.setRandomId(randomId);
            rs.add(sjcActivity);
        }
        log.info("开始存储活动信息");
        updateBatchById(rs);
        log.info("活动信息存储了{}条",rs.size());
    }
}
