package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcActivitys;
import com.tykj.sjc.zlkp_entity.SjcAleArticle;
import com.tykj.sjc.service.SjcAleArticleService;
import com.tykj.sjc.mapper.SjcAleArticleMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* @author tykj
* @description 针对表【sjc_ale_article】的数据库操作Service实现
* @createDate 2023-11-15 16:21:17
*/
@Service
@Slf4j
public class SjcAleArticleServiceImpl extends ServiceImpl<SjcAleArticleMapper, SjcAleArticle>
    implements SjcAleArticleService{

    @Resource
    private SjcAleArticleMapper sjcAleArticleMapper;

    @Resource
    private BillRemote billRemote;


    @Override
    @Transactional
    public void saveAleArticle() {
        List<SjcAleArticle> rs=new ArrayList<>();
        for (SjcAleArticle sjcAleArticle : sjcAleArticleMapper.selectList(null)) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcAleArticle.getAleAuthor())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcAleArticle.setRandomId(randomId);
            rs.add(sjcAleArticle);
        }
        log.info("开始存储文章信息");
        updateBatchById(rs);
        log.info("文章信息存储了{}条",rs.size());
    }
}




