package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcExpertsMapper;
import com.tykj.sjc.service.SjcExpertsService;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcExperts;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class SjcExpertsServiceImpl extends ServiceImpl<SjcExpertsMapper, SjcExperts> implements SjcExpertsService {

    @Resource
    private SjcExpertsMapper sjcExpertsMapper;

    @Resource
    private BillRemote billRemote;

    @Override
    @Transactional
    public void saveExperts() {
        List<SjcExperts> sjcExperts = sjcExpertsMapper.selectList(null);
        List<SjcExperts> rs=new ArrayList<>();
        for (SjcExperts sjcExpert : sjcExperts) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcExpert.getName())
                    .s2(sjcExpert.getPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcExpert.setRandomId(randomId);
            rs.add(sjcExpert);
        }
        log.info("开始存储科普专家信息");
        updateBatchById(rs);
        log.info("科普专家信息存储了{}条",rs.size());
    }
}
