package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcExperts;
import com.tykj.sjc.zlkp_entity.SjcKxActApply;
import com.tykj.sjc.service.SjcKxActApplyService;
import com.tykj.sjc.mapper.SjcKxActApplyMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* @author tykj
* @description 针对表【sjc_kx_act_apply】的数据库操作Service实现
* @createDate 2023-11-15 16:03:03
*/
@Service
@Slf4j
public class SjcKxActApplyServiceImpl extends ServiceImpl<SjcKxActApplyMapper, SjcKxActApply>
    implements SjcKxActApplyService{

    @Resource
    private SjcKxActApplyMapper sjcKxActApplyMapper;

    @Resource
    private BillRemote billRemote;

    @Override
    @Transactional
    public void saveKxActApply() {
        List<SjcKxActApply> rs=new ArrayList<>();
        for (SjcKxActApply sjcKxActApply : sjcKxActApplyMapper.selectList(null)) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcKxActApply.getCreatedBy())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcKxActApply.setRandomId(randomId);
            rs.add(sjcKxActApply);
        }
        log.info("开始存储数字少年宫-⽹上报名活动信息");
        updateBatchById(rs);
        log.info("数字少年宫-⽹上报名活动信息存储了{}条",rs.size());
    }
}




