package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcKxActivity;
import com.tykj.sjc.service.SjcKxActivityService;
import com.tykj.sjc.mapper.SjcKxActivityMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* @author tykj
* @description 针对表【sjc_kx_activity】的数据库操作Service实现
* @createDate 2023-11-15 15:33:05
*/
@Service
@Slf4j
public class SjcKxActivityServiceImpl extends ServiceImpl<SjcKxActivityMapper, SjcKxActivity>
    implements SjcKxActivityService{

    @Resource
    private  SjcKxActivityMapper sjcKxActivityMapper;

    @Resource
    private BillRemote billRemote;


    @Override
    @Transactional
    public void saveKxActivity() {
        List<SjcKxActivity> rs=new ArrayList<>();
        for (SjcKxActivity sjcKxActivity : sjcKxActivityMapper.selectList(null)) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcKxActivity.getCreatedBy())
                    .s2(sjcKxActivity.getPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcKxActivity.setRandomId(randomId);
            rs.add(sjcKxActivity);
        }
        log.info("开始存储数字少年宫-假⽇营地⾯活动信信息");
        updateBatchById(rs);
        log.info("数字少年宫-假⽇营地⾯活动信息存储了{}条",rs.size());
    }
}




