package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcKxApply;
import com.tykj.sjc.service.SjcKxApplyService;
import com.tykj.sjc.mapper.SjcKxApplyMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* @author tykj
* @description 针对表【sjc_kx_apply】的数据库操作Service实现
* @createDate 2023-11-15 15:50:18
*/
@Service
@Slf4j
public class SjcKxApplyServiceImpl extends ServiceImpl<SjcKxApplyMapper, SjcKxApply>
    implements SjcKxApplyService{

    @Resource
    private SjcKxApplyMapper sjcKxApplyMapper;

    @Resource
    private BillRemote billRemote;

    @Override
    @Transactional
    public void saveKxApply() {
        List<SjcKxApply>  rs=new ArrayList<>();
        for (SjcKxApply sjcKxApply : sjcKxApplyMapper.selectList(null)) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcKxApply.getTeacher())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcKxApply.setRandomId(randomId);
            rs.add(sjcKxApply);
        }
        log.info("开始存储数字少年宫-⽹上报名活动参与信息");
        updateBatchById(rs);
        log.info("数字少年宫-⽹上报名活动参与信息存储了{}条",rs.size());
    }
}




