package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcKxApply;
import com.tykj.sjc.zlkp_entity.SjcKxLdActiveManagement;
import com.tykj.sjc.service.SjcKxLdActiveManagementService;
import com.tykj.sjc.mapper.SjcKxLdActiveManagementMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* @author tykj
* @description 针对表【sjc_kx_ld_active_management】的数据库操作Service实现
* @createDate 2023-11-15 16:10:53
*/
@Service
@Slf4j
public class SjcKxLdActiveManagementServiceImpl extends ServiceImpl<SjcKxLdActiveManagementMapper, SjcKxLdActiveManagement>
    implements SjcKxLdActiveManagementService{

    @Resource
    private SjcKxLdActiveManagementMapper sjcKxLdActiveManagementMapper;

    @Resource
    private BillRemote billRemote;


    @Override
    @Transactional
    public void saveKxLdActiveManagement() {
        List<SjcKxLdActiveManagement> rs=new ArrayList<>();
        for (SjcKxLdActiveManagement sjcKxLdActiveManagement : sjcKxLdActiveManagementMapper.selectList(null)) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcKxLdActiveManagement.getPerson())
                    .s2(sjcKxLdActiveManagement.getPhonenumber())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcKxLdActiveManagement.setRandomId(randomId);
            rs.add(sjcKxLdActiveManagement);
        }
        log.info("开始存储科普专题信息");
        updateBatchById(rs);
        log.info("科普专题信息存储了{}条",rs.size());
    }
}




