package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcAleArticle;
import com.tykj.sjc.zlkp_entity.SjcKxSourceSpecial;
import com.tykj.sjc.service.SjcKxSourceSpecialService;
import com.tykj.sjc.mapper.SjcKxSourceSpecialMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* @author tykj
* @description 针对表【sjc_kx_source_special】的数据库操作Service实现
* @createDate 2023-11-15 16:27:40
*/
@Service
@Slf4j
public class SjcKxSourceSpecialServiceImpl extends ServiceImpl<SjcKxSourceSpecialMapper, SjcKxSourceSpecial>
    implements SjcKxSourceSpecialService{

    @Resource
    private SjcKxSourceSpecialMapper sjcKxSourceSpecialMapper;

    @Resource
    private BillRemote billRemote;


    @Override
    @Transactional
    public void saveKxSourceSpecial() {
            List<SjcKxSourceSpecial> rs=new ArrayList<>();
        for (SjcKxSourceSpecial sjcKxSourceSpecial : sjcKxSourceSpecialMapper.selectList(null)) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcKxSourceSpecial.getCreateUserName())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcKxSourceSpecial.setRandomId(randomId);
            rs.add(sjcKxSourceSpecial);
        }
        log.info("开始存储数字少年宫-流动少年宫活动");
        updateBatchById(rs);
        log.info("数字少年宫-流动少年宫活动信息存储了{}条",rs.size());
    }
}




