package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcQuestsMapper;
import com.tykj.sjc.service.SjcQuestsService;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcQuests;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class SjcQuestsServiceImpl extends ServiceImpl<SjcQuestsMapper, SjcQuests> implements SjcQuestsService {

    @Resource
    private SjcQuestsMapper sjcQuestsMapper;

    @Resource
    private BillRemote billRemote;


    @Override
    @Transactional
    public void saveQuests() {
        List<SjcQuests> sjcQuests = sjcQuestsMapper.selectList(null);
        List<SjcQuests> rs=new ArrayList<>();
        for (SjcQuests sjcQuest : sjcQuests) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcQuest.getName())
                    .s2(sjcQuest.getPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcQuest.setRandomId(randomId);
            rs.add(sjcQuest);
        }
        log.info("开始存储银龄问卷反馈信息");
        updateBatchById(rs);
        log.info("银龄问卷反馈信息存储了{}条",rs.size());
    }
}
