package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcShareYlActivitiesMapper;
import com.tykj.sjc.service.SjcShareYlActivitiesService;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcShareYlActivities;
import lombok.extern.slf4j.Slf4j;
import net.bytebuddy.matcher.FilterableList;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class SjcShareYlActivitiesServiceImpl extends ServiceImpl<SjcShareYlActivitiesMapper, SjcShareYlActivities> implements SjcShareYlActivitiesService {

    @Resource
    private SjcShareYlActivitiesMapper sjcShareYlActivitiesMapper;

    @Resource
    private BillRemote billRemote;

    @Override
    @Transactional
    public void saveShareYlActivities() {
        List<SjcShareYlActivities> sjcShareYlActivities = sjcShareYlActivitiesMapper.selectList(null);
        List<SjcShareYlActivities> rs = new ArrayList<>();
        for (SjcShareYlActivities sjcShareYlActivity : sjcShareYlActivities) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcShareYlActivity.getContactPerson())
                    .s2(sjcShareYlActivity.getContactPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcShareYlActivity.setRandomId(randomId);
            rs.add(sjcShareYlActivity);
        }
        log.info("开始存储银铃活动信息");
        updateBatchById(rs);
        log.info("银铃活动信息存储了{}条",rs.size());
    }
}
