package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcShareYlActivityAppliesMapper;
import com.tykj.sjc.service.SjcShareYlActivityAppliesService;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcShareYlActivityApplies;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class SjcShareYlActivityAppliesServiceImpl extends ServiceImpl<SjcShareYlActivityAppliesMapper, SjcShareYlActivityApplies> implements SjcShareYlActivityAppliesService {

    @Resource
    private SjcShareYlActivityAppliesMapper sjcShareYlActivityAppliesMapper;

    @Resource
    private BillRemote billRemote;

    @Override
    @Transactional
    public void saveShareYlActivityApplies() {
        List<SjcShareYlActivityApplies> sjcShareYlActivityApplies = sjcShareYlActivityAppliesMapper.selectList(null);
        List<SjcShareYlActivityApplies> rs=new ArrayList<>();
        for (SjcShareYlActivityApplies sjcShareYlActivityApply : sjcShareYlActivityApplies) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcShareYlActivityApply.getName())
                    .s2(sjcShareYlActivityApply.getPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcShareYlActivityApply.setRandomId(randomId);
            rs.add(sjcShareYlActivityApply);
        }
        log.info("开始存储银龄参与活动人员信息");
        updateBatchById(rs);
        log.info("银龄参与活动人员信息存储了{}条",rs.size());
    }
}
