package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcShareYlBranchesMapper;
import com.tykj.sjc.service.SjcShareYlBranchesService;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcShareYlBranches;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class SjcShareYlBranchesServiceImpl extends ServiceImpl<SjcShareYlBranchesMapper, SjcShareYlBranches> implements SjcShareYlBranchesService {

    @Resource
    private SjcShareYlBranchesMapper sjcShareYlBranchesMapper;

    @Resource
    private BillRemote billRemote;



    @Override
    @Transactional
    public void saveShareYlBranches() {
        List<SjcShareYlBranches> sjcShareYlBranches = sjcShareYlBranchesMapper.selectList(null);
        List<SjcShareYlBranches> rs=new ArrayList<>();
        for (SjcShareYlBranches sjcShareYlBranch : sjcShareYlBranches) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcShareYlBranch.getContactPerson())
                    .s2(sjcShareYlBranch.getContactPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcShareYlBranch.setRandomId(randomId);
            rs.add(sjcShareYlBranch);
        }
        log.info("开始存储银龄网点信息");
        updateBatchById(rs);
        log.info("银龄网点信息存储了{}条",rs.size());
    }
}
