package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.mapper.SjcShareYlVolunteerApplysMapper;
import com.tykj.sjc.service.SjcShareYlVolunteerApplysService;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcShareYlVolunteerApplys;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class SjcShareYlVolunteerApplysServiceImpl extends ServiceImpl<SjcShareYlVolunteerApplysMapper, SjcShareYlVolunteerApplys> implements SjcShareYlVolunteerApplysService {

    @Resource
    private SjcShareYlVolunteerApplysMapper sjcShareYlVolunteerApplysMapper;

    @Resource
    private BillRemote billRemote;

    @Override
    @Transactional
    public void saveShareYlVolunteerApplys() {
        List<SjcShareYlVolunteerApplys> sjcShareYlVolunteerApplys = sjcShareYlVolunteerApplysMapper.selectList(null);
        List<SjcShareYlVolunteerApplys> rs=new ArrayList<>();
        for (SjcShareYlVolunteerApplys sjcShareYlVolunteerApply : sjcShareYlVolunteerApplys) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcShareYlVolunteerApply.getName())
                    .s2(sjcShareYlVolunteerApply.getPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcShareYlVolunteerApply.setRandomId(randomId);
            rs.add(sjcShareYlVolunteerApply);
        }
        log.info("开始存储银龄志愿信息");
        updateBatchById(rs);
        log.info("银龄志愿信息存储了{}条",rs.size());
    }
}
