package com.tykj.sjc.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tykj.sjc.util.BillDTO;
import com.tykj.sjc.util.BillRemote;
import com.tykj.sjc.zlkp_entity.SjcTechnologyBases;
import com.tykj.sjc.service.SjcTechnologyBasesService;
import com.tykj.sjc.mapper.SjcTechnologyBasesMapper;
import jdk.nashorn.internal.ir.annotations.Reference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* @author tykj
* @description 针对表【sjc_technology_bases】的数据库操作Service实现
* @createDate 2023-11-15 15:15:52
*/
@Service
@Slf4j
public class SjcTechnologyBasesServiceImpl extends ServiceImpl<SjcTechnologyBasesMapper, SjcTechnologyBases>
    implements SjcTechnologyBasesService{

    @Resource
    private SjcTechnologyBasesMapper sjcTechnologyBasesMapper;

    @Resource
    private BillRemote billRemote;

    @Override
    @Transactional
    public void saveTechnologyBases() {
        List<SjcTechnologyBases> rs=new ArrayList<>();
        for (SjcTechnologyBases sjcTechnologyBases : sjcTechnologyBasesMapper.selectList(null)) {
            BillDTO build = BillDTO.builder()
                    .s1(sjcTechnologyBases.getContactPerson())
                    .s2(sjcTechnologyBases.getContactPhone())
                    .build();
            String randomId = billRemote.sendSaveBill(build);
            sjcTechnologyBases.setRandomId(randomId);
            rs.add(sjcTechnologyBases);
        }
        log.info("开始存基地信息");
        updateBatchById(rs);
        log.info("基地信息存储了{}条",rs.size());
    }
}




