package com.tykj.sjc.zlkp_entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Data;

/**
 * 
 * @TableName sjc_ale_article
 */
@TableName(value ="sjc_ale_article")
@Data
public class SjcAleArticle implements Serializable {
    /**
     * 
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 来源
     */
    @TableField(value = "ale_source")
    private String aleSource;

    /**
     * 数据更新时间
     */
    @TableField(value = "ale_update_date")
    private LocalDateTime aleUpdateDate;

    /**
     * 关键字
     */
    @TableField(value = "ale_keyword")
    private String aleKeyword;

    /**
     * 点击量
     */
    @TableField(value = "ale_click")
    private String aleClick;

    /**
     * 信息标题
     */
    @TableField(value = "ale_title")
    private String aleTitle;

    /**
     * 摘要
     */
    @TableField(value = "ale_ads")
    private String aleAds;

    /**
     * 数据创建时间
     */
    @TableField(value = "ale_create_date")
    private LocalDateTime aleCreateDate;

    /**
     * 作者
     */
    @TableField(value = "ale_author")
    private String aleAuthor;

    /**
     * 正文
     */
    @TableField(value = "ale_content")
    private String aleContent;

    /**
     * 敏感字段随机值
     */
    @TableField(value = "random_id")
    private String randomId;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        SjcAleArticle other = (SjcAleArticle) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getAleSource() == null ? other.getAleSource() == null : this.getAleSource().equals(other.getAleSource()))
            && (this.getAleUpdateDate() == null ? other.getAleUpdateDate() == null : this.getAleUpdateDate().equals(other.getAleUpdateDate()))
            && (this.getAleKeyword() == null ? other.getAleKeyword() == null : this.getAleKeyword().equals(other.getAleKeyword()))
            && (this.getAleClick() == null ? other.getAleClick() == null : this.getAleClick().equals(other.getAleClick()))
            && (this.getAleTitle() == null ? other.getAleTitle() == null : this.getAleTitle().equals(other.getAleTitle()))
            && (this.getAleAds() == null ? other.getAleAds() == null : this.getAleAds().equals(other.getAleAds()))
            && (this.getAleCreateDate() == null ? other.getAleCreateDate() == null : this.getAleCreateDate().equals(other.getAleCreateDate()))
            && (this.getAleAuthor() == null ? other.getAleAuthor() == null : this.getAleAuthor().equals(other.getAleAuthor()))
            && (this.getAleContent() == null ? other.getAleContent() == null : this.getAleContent().equals(other.getAleContent()))
            && (this.getRandomId() == null ? other.getRandomId() == null : this.getRandomId().equals(other.getRandomId()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getAleSource() == null) ? 0 : getAleSource().hashCode());
        result = prime * result + ((getAleUpdateDate() == null) ? 0 : getAleUpdateDate().hashCode());
        result = prime * result + ((getAleKeyword() == null) ? 0 : getAleKeyword().hashCode());
        result = prime * result + ((getAleClick() == null) ? 0 : getAleClick().hashCode());
        result = prime * result + ((getAleTitle() == null) ? 0 : getAleTitle().hashCode());
        result = prime * result + ((getAleAds() == null) ? 0 : getAleAds().hashCode());
        result = prime * result + ((getAleCreateDate() == null) ? 0 : getAleCreateDate().hashCode());
        result = prime * result + ((getAleAuthor() == null) ? 0 : getAleAuthor().hashCode());
        result = prime * result + ((getAleContent() == null) ? 0 : getAleContent().hashCode());
        result = prime * result + ((getRandomId() == null) ? 0 : getRandomId().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", aleSource=").append(aleSource);
        sb.append(", aleUpdateDate=").append(aleUpdateDate);
        sb.append(", aleKeyword=").append(aleKeyword);
        sb.append(", aleClick=").append(aleClick);
        sb.append(", aleTitle=").append(aleTitle);
        sb.append(", aleAds=").append(aleAds);
        sb.append(", aleCreateDate=").append(aleCreateDate);
        sb.append(", aleAuthor=").append(aleAuthor);
        sb.append(", aleContent=").append(aleContent);
        sb.append(", randomId=").append(randomId);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}