package com.tykj.zydd.misc.sm_utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author: zsp
 * @create: 2023-09-13 16:34
 **/
public class StringMatchUtil {
    /**
     * 要求字符串长度8位数以上，需包含英文大写字母、小写字母、数字以及非字母字符中三类字符
     */
    public static  final String REGEX = "^(?=.*[A-Z])|(?=.*[a-z])|(?=.*\\d)|(?=.*[^A-Za-z0-9]).{8,}$";

    /**
     * 验证数字是否符合规则
     * @param s
     * @return
     */
    public static Boolean matchString(String s) {
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(s);
        return matcher.matches();
    }

    public static void main(String[] args) {
//        String password = "zlkp@0530abc";
        String password = "zlkp@0530ab";
        boolean isValid = matchString(password);
        if (isValid) {
            System.out.println("密码有效");
            //判断是否连续
            judgeLine(password);
        } else {
            System.out.println("密码无效");
        }
    }

    /**
     * 判断是否连续
     * @param password
     */
    public static Boolean judgeLine(String password) {
        for (int i = 0; i < password.length(); i++) {
            if (i == 0 || i == password.length() -1){
                continue;
            }
            int c2 = (int) password.charAt(i);
            int c1 = (int) password.charAt(i-1);
            int c3 = (int) password.charAt(i+1);
            if (c2 == c1+1 && c2 == c3-1){
//                System.out.println("连续");
//                throw new ApiException("密码不符合要求,请重新设置密码");
                return false;
            }
//            else {
//                System.out.println("不连续");
//            }
        }
        return true;
    }
}
