package com.tykj.zydd.misc.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.tykj.zydd.misc.exception.ApiException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import javax.servlet.http.HttpServletResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * pdf相关工具类
 * 注意事项：
 * 1、时间类型需要转成字符串
 * 2、只支持对象嵌对象，两层结构；对象嵌对象再嵌对象，第三层对象无法解析，如果遇到这种情况需要写成递归或解析第三次。
 */
@Slf4j
public class PdfUtil {

    private static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.getName().startsWith("java.lang");
    }

    private static Map<String, String> turnMap(Object object) {
        Map<String, Object> stringObjectMap = BeanUtil.beanToMap(object);
        Map<String, String> map = new HashMap<>(stringObjectMap.size() * 2);
        // 打印输出属性名称和属性值
        for (Map.Entry<String, Object> entry : stringObjectMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (ObjectUtil.isNotEmpty(value)) {
                //基本类型和封装类型
                if (isPrimitiveOrWrapper(value.getClass())) {
                    map.put(key, String.valueOf(value));
                } else {
                    //其他类型
                    if (value instanceof List) {
                        List<Object> list = (List) value;
                        for (int i = 0; i < list.size(); i++) {
                            Object o = list.get(i);
                            Map<String, Object> stringObjectMap1 = BeanUtil.beanToMap(o);
                            for (Map.Entry<String, Object> entry1 : stringObjectMap1.entrySet()) {
                                String key1 = entry1.getKey();
                                Object value1 = entry1.getValue();
                                map.put(StrUtil.format("{}.{}{}", key, key1, i), String.valueOf(value1));
                            }
                        }
                    } else {
                        Map<String, Object> stringObjectMap1 = BeanUtil.beanToMap(value);
                        for (Map.Entry<String, Object> entry1 : stringObjectMap1.entrySet()) {
                            String key1 = entry1.getKey();
                            Object value1 = entry1.getValue();
                            map.put(StrUtil.format("{}.{}", key, key1), String.valueOf(value1));
                        }
                    }
                }
            }
        }
        return map;
    }

/*
    public static void generatePdf(HttpServletResponse response,
                                   Resource resource, Object object,String fileName) {
        try (OutputStream outputStream = response.getOutputStream()) {
            setType(response,fileName);
            //模板在项目中的位置
            PdfReader reader=new PdfReader(resource.getInputStream());
            PdfStamper ps = new PdfStamper(reader, outputStream);
            BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA_BOLD, BaseFont.WINANSI, BaseFont.EMBEDDED);
            ArrayList<BaseFont> fontList = new ArrayList<>();
            fontList.add(bf);
            //取出报表模板中的所有字段
            AcroFields fields = ps.getAcroFields();
            fields.setSubstitutionFonts(fontList);
            PdfUtil.fillData(fields, PdfUtil.turnMap(object));
            //必须要调用这个，否则文档不会生成的  如果为false那么生成的PDF文件还能编辑，一定要设为true
            ps.setFormFlattening(true);
            ps.close();
            reader.close();
        } catch (Exception e) {
            log.error("pdf生成异常：", e);
            throw new RuntimeException("操作异常请联系管理员！");
        }
    }
*/

    public  static void  generatePdf(HttpServletResponse response,String templatePath,Object object,String fileName){
        try (OutputStream outputStream = response.getOutputStream()) {
            setType(response,fileName);
            FileInputStream inputStream = new FileInputStream(templatePath);
            PdfReader reader=new PdfReader(inputStream);
            PdfStamper ps = new PdfStamper(reader, outputStream);
            BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA_BOLD, BaseFont.WINANSI, BaseFont.EMBEDDED);
            float fontSize = 12f;
            ArrayList<BaseFont> fontList = new ArrayList<>();
            fontList.add(bf);
            //取出报表模板中的所有字段
            AcroFields fields = ps.getAcroFields();
            fields.setSubstitutionFonts(fontList);
            for (String fieldName : fields.getFields().keySet()) {
                // 设置字段的字体和字体大小
                fields.setFieldProperty(fieldName, "textsize", fontSize, null);
            }
            PdfUtil.fillData(fields, PdfUtil.turnMap(object));
            //必须要调用这个，否则文档不会生成的  如果为false那么生成的PDF文件还能编辑，一定要设为true
            ps.setFormFlattening(true);
            ps.close();
            reader.close();
        } catch (Exception e) {
            e.printStackTrace();
            log.error("pdf转换异常{}", e.getMessage());
            throw new ApiException("pdf转换异常");
        }
    }
    /**
     * 填充数据
     *
     * @param fields  字段
     * @param data  数据
     * @throws Exception
     */
    private static void fillData(AcroFields fields, Map<String, String> data) throws Exception {
        Map<String, AcroFields.Item> formFields = fields.getFields();
        for (String key : data.keySet()) {
            if (formFields.containsKey(key)) {
                String value = data.get(key);
                // 为字段赋值，注意字段名称是区分大小写的
                fields.setField(key, value);
            }
        }
    }


    private static void setType(HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        response.setContentType("application/pdf;charset=UTF-8");
        response.setCharacterEncoding("utf-8");
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".pdf");
    }
    public static void main(String[] args) throws IOException {
        Resource resource = new ClassPathResource("/templates/userOnJob.pdf"); // 获取资源文件夹的路径
        String resourcePath = resource.getFile().getAbsolutePath();
        System.out.println("Resource Path: " + resourcePath);
        PdfReader reader = new PdfReader(resource.getInputStream());

        System.out.println();
        /*String pdfFilePath = "userOnJob.pdf";
        Resource resource = new ClassPathResource(pdfFilePath);
        System.out.println( resource.getURI() + " -- ****** path = ");
        if (resource.isReadable()) {
            //PdfReader reader=new PdfReader(pdfFilePath);
            //每次都会打开一个新的流
            InputStream is = resource.getInputStream();
            System.out.println("方法一 " + is.available());
        }
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(pdfFilePath);
        System.out.println("方法二 " + inputStream.available());*/
    }
}

