package com.tykj.zydd.pickup.controller;


import com.tykj.zydd.misc.swagger.AutoDocument;
import com.tykj.zydd.pickup.entity.PickUp;
import com.tykj.zydd.pickup.entity.dto.NotificationDTO;
import com.tykj.zydd.pickup.entity.dto.PickUpDTO;
import com.tykj.zydd.pickup.entity.vo.NotificationVO;
import com.tykj.zydd.pickup.service.PickUpService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Api(tags = "通知取件")
@Slf4j
@RequestMapping("/cr")
@AutoDocument
public class PickUpController {

    @Resource
    private PickUpService pickUpService;

    @PostMapping ("/getListPickUp")
    @ApiOperation(value = "通知取件查看")
    public List<PickUp> getListPickUp(@RequestBody PickUpDTO pickUpDTO){
        return  pickUpService.getListPickUp(pickUpDTO);
    }

    @PostMapping ("/getNotificationList")
    @ApiOperation(value = "传入接收单位获取该单位下的通知人员")
    public List<NotificationVO> getNotificationList(@RequestParam List<String> unitName){
        return  pickUpService.getNotificationList(unitName);
    }

    @PostMapping ("/notification")
    @ApiOperation(value = "发送消息通知 ")
    public void notification(@RequestBody List<NotificationDTO> notificationDTOList){
        pickUpService.notification(notificationDTOList);
    }
}
