package com.tykj.zydd.pickup.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Entity;
import java.time.LocalDateTime;

@Data
@ApiModel("通知取件")
@Entity
@SQLDelete(sql = "update pick_up set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
public class PickUp extends BaseEntity{


    @ApiModelProperty(value = "通知时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private LocalDateTime notificationTime;

    @ApiModelProperty(value = "通知单位")
    private String fromUnitName;

    @ApiModelProperty(value = "通知人")
    private String fromUser;

    @ApiModelProperty(value = "接收单位")
    private String toUnitName;

    @ApiModelProperty(value = "接收人")
    private String toUnitUser;

    @ApiModelProperty(value = "接收电话")
    private String toUnitPhone;

    @ApiModelProperty(value = "状态 0成功 1失败")
    private Integer status;

    @ApiModelProperty("所属单位")
    private String organizationCode;
}
